/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InvalidateODFRootPageCacheOnPageDeleteObserver
implements Observer,
Serviceable {
    private OdfPageHandler _odfPageHandler;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Event event) {
        return event.getId().equals("page.deleting");
    }

    public int getPriority() {
        return 4000;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String pageId = (String)event.getArguments().get("page.id");
        Page page = (Page)this._resolver.resolveById(pageId);
        if (this._odfPageHandler.isODFRootPage(page)) {
            this._odfPageHandler.clearRootCache();
        }
    }
}

