/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.odfweb.repository.AbstractProgramItemPage;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.repository.CoursePageFactory;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.odfweb.repository.ProgramPageFactory;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class OdfPageResolver
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = OdfPageResolver.class.getName();
    private static final String __PATH_IN_SITEMAP_CACHE = OdfPageResolver.class.getName() + "$pathInSitemap";
    private static final String __RESOLVED_PATH_CACHE = OdfPageResolver.class.getName() + "$resolvedPath";
    private static final String __ODF_ROOT_PROGRAM_CACHE = OdfPageResolver.class.getName() + "$rootProgram";
    protected AmetysObjectResolver _ametysResolver;
    protected OdfPageHandler _odfPageHandler;
    protected ODFHelper _odfHelper;
    protected AbstractCacheManager _cacheManager;
    protected CoursePageFactory _coursePageFactory;
    protected ProgramPageFactory _programPageFactory;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._ametysResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)serviceManager.lookup(OdfPageHandler.ROLE));
        this._odfHelper = (ODFHelper)serviceManager.lookup(ODFHelper.ROLE);
        this._cacheManager = (AbstractCacheManager)serviceManager.lookup(AbstractCacheManager.ROLE);
        AmetysObjectFactoryExtensionPoint ametysObjectFactoryEP = (AmetysObjectFactoryExtensionPoint)serviceManager.lookup(AmetysObjectFactoryExtensionPoint.ROLE);
        this._coursePageFactory = (CoursePageFactory)((Object)ametysObjectFactoryEP.getExtension(CoursePageFactory.class.getName()));
        this._programPageFactory = (ProgramPageFactory)((Object)ametysObjectFactoryEP.getExtension(ProgramPageFactory.class.getName()));
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(__PATH_IN_SITEMAP_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_PATH_IN_SITEMAP_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_PATH_IN_SITEMAP_DESCRIPTION"), false);
        this._cacheManager.createRequestCache(__RESOLVED_PATH_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_RESOLVED_PATH_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_RESOLVED_PATH_DESCRIPTION"), false);
        this._cacheManager.createRequestCache(__ODF_ROOT_PROGRAM_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ROOT_PROGRAM_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ROOT_PROGRAM_DESCRIPTION"), false);
    }

    public Set<Page> getReferencingPages(ProgramItem programItem) {
        return this.getReferencingPages(programItem, null, ((Content)programItem).getLanguage());
    }

    public Set<Page> getReferencingPages(ProgramItem programItem, String siteName, String lang) {
        HashSet<Page> refPages = new HashSet<Page>();
        Set<Page> odfRootPages = this._odfPageHandler.getOdfRootPages(siteName, lang);
        for (Page rootPage : odfRootPages) {
            if (programItem instanceof Program) {
                ProgramPage programPage = this.getProgramPage(rootPage, (Program)programItem);
                if (programPage == null) continue;
                refPages.add((Page)programPage);
                continue;
            }
            if (programItem instanceof SubProgram) {
                Set parentPrograms = this._odfHelper.getParentPrograms(programItem);
                for (Program parentProgram : parentPrograms) {
                    ProgramPage subProgramPage = this.getSubProgramPage(rootPage, (SubProgram)programItem, (AbstractProgram)parentProgram);
                    if (subProgramPage == null) continue;
                    refPages.add((Page)subProgramPage);
                }
                continue;
            }
            if (!(programItem instanceof Course)) continue;
            List parentCourseLists = ((Course)programItem).getParentCourseLists();
            for (CourseList courseList : parentCourseLists) {
                List parentCourses = courseList.getParentCourses();
                for (Course parentCourse : parentCourses) {
                    CoursePage coursePage = this.getCoursePage(rootPage, (Course)programItem, parentCourse);
                    if (coursePage == null) continue;
                    refPages.add((Page)coursePage);
                }
                List<AbstractProgram> parentAbstractPrograms = this.getNearestAncestorAbstractPrograms((ProgramPart)courseList);
                for (AbstractProgram parentAbstractProgram : parentAbstractPrograms) {
                    CoursePage coursePage = this.getCoursePage(rootPage, (Course)programItem, parentAbstractProgram);
                    if (coursePage == null) continue;
                    refPages.add((Page)coursePage);
                }
            }
        }
        return refPages;
    }

    public ProgramPage getProgramPage(Program program) {
        return this.getProgramPage(program, null);
    }

    public ProgramPage getProgramPage(Program program, String siteName) {
        Page odfRootPage = this.getOdfRootPage(siteName, program.getLanguage(), program.getCatalog());
        if (odfRootPage == null) {
            return null;
        }
        return this.getProgramPage(odfRootPage, program);
    }

    public ProgramPage getProgramPage(Page odfRootPage, Program program) {
        String pageId = "program://_root?rootId=" + odfRootPage.getId() + "&programId=" + program.getId();
        try {
            return (ProgramPage)this._ametysResolver.resolveById(pageId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public ProgramPage getSubProgramPage(SubProgram subProgram, AbstractProgram parentProgram, String siteName) {
        Page odfRootPage = this.getOdfRootPage(siteName, subProgram.getLanguage(), subProgram.getCatalog());
        if (odfRootPage == null) {
            return null;
        }
        return this.getSubProgramPage(odfRootPage, subProgram, parentProgram);
    }

    public ProgramPage getSubProgramPage(Page odfRootPage, SubProgram subProgram, AbstractProgram parentAbstractProgram) {
        try {
            Program parentProgram = this.getRootProgram(odfRootPage, (ProgramItem)subProgram, parentAbstractProgram);
            if (parentProgram == null) {
                return null;
            }
            AbstractProgram parent = this.getNearestAncestorAbstractProgram((ProgramItem)subProgram, parentAbstractProgram);
            if (parent == null) {
                return null;
            }
            String path = this.getPathInProgram((ProgramItem)parent, (AbstractProgram)parentProgram);
            if (path == null) {
                return null;
            }
            return this._programPageFactory.createProgramPage(odfRootPage, (AbstractProgram)subProgram, path, parentProgram, null);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public ProgramPage getSubProgramPage(Page odfRootPage, SubProgram subProgram, List<String> path, boolean checkHierarchy) {
        try {
            ProgramItem nextProgramItem;
            ProgramItem lastParent = (ProgramItem)this._ametysResolver.resolveById(path.get(0));
            Program parentProgram = this.getRootProgram(odfRootPage, lastParent, null);
            if (parentProgram == null) {
                return null;
            }
            SequencedCollection reversedPath = path.reversed();
            if (checkHierarchy && !this._checkHierarchy((ProgramItem)subProgram, nextProgramItem = (ProgramItem)this._ametysResolver.resolveById(path.getLast()))) {
                this.getLogger().warn(String.valueOf(reversedPath) + " is not valid hierarchy");
                throw new UnknownAmetysObjectException(String.valueOf(reversedPath) + " is not valid hierarchy");
            }
            String pagePath = this._resolvePagePath((List<String>)reversedPath, checkHierarchy);
            if (pagePath == null) {
                return null;
            }
            return this._programPageFactory.createProgramPage(odfRootPage, (AbstractProgram)subProgram, pagePath, parentProgram, null);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public CoursePage getCoursePage(Course course, AbstractProgram parentProgram, String siteName) {
        String catalog = course.getCatalog();
        Page odfRootPage = this.getOdfRootPage(siteName, course.getLanguage(), catalog);
        if (odfRootPage == null) {
            return null;
        }
        return this.getCoursePage(odfRootPage, course, parentProgram);
    }

    public CoursePage getCoursePage(Page odfRootPage, Course course, AbstractProgram parentAbstractProgram) {
        try {
            Program parentProgram = this.getRootProgram(odfRootPage, (ProgramItem)course, parentAbstractProgram);
            if (parentProgram == null) {
                return null;
            }
            Object parent = null;
            Course parentCourse = this.getNearestAncestorCourse(course, parentAbstractProgram);
            parent = parentCourse != null ? parentCourse : this.getNearestAncestorAbstractProgram((ProgramItem)course, parentAbstractProgram);
            if (parent == null) {
                return null;
            }
            String path = this.getPathInProgram((ProgramItem)parent, (AbstractProgram)parentProgram);
            if (path == null) {
                return null;
            }
            return this._coursePageFactory.createCoursePage(odfRootPage, course, parentProgram, path, null);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public CoursePage getCoursePage(Course course, Course parentCourse, String siteName) {
        String catalog = course.getCatalog();
        Page odfRootPage = this.getOdfRootPage(siteName, course.getLanguage(), catalog);
        if (odfRootPage == null) {
            return null;
        }
        return this.getCoursePage(odfRootPage, course, parentCourse);
    }

    public CoursePage getCoursePage(Page odfRootPage, Course course, Course parentCourse) {
        try {
            Program parentProgram = this.getRootProgram(odfRootPage, (ProgramItem)parentCourse, null);
            if (parentProgram == null) {
                return null;
            }
            String path = this.getPathInProgram((ProgramItem)parentCourse, (AbstractProgram)parentProgram);
            if (path == null) {
                return null;
            }
            return this._coursePageFactory.createCoursePage(odfRootPage, course, parentProgram, path, null);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public CoursePage getCoursePage(Page odfRootPage, Course course, List<String> path) {
        return this.getCoursePage(odfRootPage, course, path, false);
    }

    public CoursePage getCoursePage(Page odfRootPage, Course course, List<String> path, boolean checkHierarchy) {
        try {
            ProgramItem nextProgramItem;
            ProgramItem lastParent = (ProgramItem)this._ametysResolver.resolveById(path.get(0));
            Program rootProgram = this.getRootProgram(odfRootPage, lastParent, null);
            if (rootProgram == null) {
                return null;
            }
            SequencedCollection reversedPath = path.reversed();
            if (checkHierarchy && !this._checkHierarchy((ProgramItem)course, nextProgramItem = (ProgramItem)this._ametysResolver.resolveById(path.getLast()))) {
                this.getLogger().warn(String.valueOf(reversedPath) + " is not valid hierarchy");
                throw new UnknownAmetysObjectException(String.valueOf(reversedPath) + " is not valid hierarchy");
            }
            String pagePath = this._resolvePagePath((List<String>)reversedPath, checkHierarchy);
            if (pagePath == null) {
                return null;
            }
            return this._coursePageFactory.createCoursePage(odfRootPage, course, rootProgram, pagePath, null);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public boolean isProgramPageExist(Page odfRootPage, Program program) {
        if (program == null || !this._odfPageHandler.isValidRestriction(odfRootPage, program)) {
            return false;
        }
        String levelsPath = this._odfPageHandler.computeLevelsPath(odfRootPage, program);
        return levelsPath != null;
    }

    public Page getOdfRootPage(String siteName, String language, String catalog) {
        Page odfRootPage = null;
        if (StringUtils.isNotEmpty((CharSequence)siteName)) {
            odfRootPage = this._odfPageHandler.getOdfRootPage(siteName, language, catalog);
        }
        if (odfRootPage == null) {
            String odfSiteName = (String)Config.getInstance().getValue("odf.web.site.name");
            odfRootPage = this._odfPageHandler.getOdfRootPage(odfSiteName, language, catalog);
        }
        return odfRootPage;
    }

    private String _resolvePagePath(List<String> reversedPath, boolean checkHierarchy) {
        Cache cache = this._cacheManager.get(__RESOLVED_PATH_CACHE);
        return (String)cache.get((Object)StringUtils.join(reversedPath, (String)";"), item -> {
            String pagePath = null;
            try {
                if (reversedPath.size() == 1) {
                    ProgramItem programItem = (ProgramItem)this._ametysResolver.resolveById((String)reversedPath.get(0));
                    pagePath = this.getPathInProgram(programItem, null);
                } else {
                    Object parentPath = this._resolvePagePath(reversedPath.subList(1, reversedPath.size()), checkHierarchy);
                    if (parentPath != null) {
                        ProgramItem nextProgramItem;
                        ProgramItem programItem = (ProgramItem)this._ametysResolver.resolveById((String)reversedPath.get(0));
                        if (checkHierarchy && !this._checkHierarchy(programItem, nextProgramItem = (ProgramItem)this._ametysResolver.resolveById((String)reversedPath.get(1)))) {
                            this.getLogger().warn(String.valueOf(reversedPath) + " is not valid hierarchy");
                            throw new UnknownAmetysObjectException(String.valueOf(reversedPath) + " is not valid hierarchy");
                        }
                        if (programItem instanceof AbstractProgram || programItem instanceof Course) {
                            parentPath = (String)parentPath + "/" + this._odfPageHandler.getPageName(programItem);
                        }
                        pagePath = parentPath;
                    }
                }
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                // empty catch block
            }
            cache.put((Object)StringUtils.join((Iterable)reversedPath, (String)";"), pagePath);
            return pagePath;
        });
    }

    private boolean _checkHierarchy(ProgramItem childProgramItem, ProgramItem nextParentProgramItem) {
        List parentProgramItems = this._odfHelper.getParentProgramItems(childProgramItem);
        if (parentProgramItems.contains(nextParentProgramItem)) {
            return true;
        }
        for (ProgramItem parentProgramItem : parentProgramItems) {
            if (parentProgramItem instanceof AbstractProgram || parentProgramItem instanceof Course || !this._checkHierarchy(parentProgramItem, nextParentProgramItem)) continue;
            return true;
        }
        return false;
    }

    public String getPathInProgram(ProgramItem programItem, AbstractProgram parentProgram) {
        Cache cache = this._cacheManager.get(__PATH_IN_SITEMAP_CACHE);
        return (String)cache.get((Object)PathInProgramCacheKey.of(programItem.getId(), parentProgram != null ? parentProgram.getId() : "__NOPARENT"), item -> {
            String parentPath;
            if (programItem instanceof Program || programItem.equals((Object)parentProgram)) {
                return this._odfPageHandler.getPageName(programItem);
            }
            ArrayList<String> paths = new ArrayList<String>();
            ProgramItem parent = this._odfHelper.getParentProgramItem(programItem, parentProgram);
            if (parent != null && (parentPath = this.getPathInProgram(parent, parentProgram)) != null) {
                paths.add(parentPath);
            }
            if (programItem instanceof AbstractProgram || programItem instanceof Course) {
                paths.add(this._odfPageHandler.getPageName(programItem));
            }
            return paths.isEmpty() ? null : StringUtils.join(paths, (String)"/");
        });
    }

    public Program getRootProgram(Page odfRootPage, ProgramItem programItem, AbstractProgram parentAbstractProgram) {
        Cache rootCache = this._cacheManager.get(__ODF_ROOT_PROGRAM_CACHE);
        return (Program)rootCache.get((Object)RootProgramCacheKey.of(odfRootPage, programItem.getId(), parentAbstractProgram != null ? parentAbstractProgram.getId() : "__NOPARENT"), k -> {
            Set<Program> parentPrograms = this._getParentPrograms(programItem, parentAbstractProgram);
            Optional<Program> parentProgram = parentPrograms.stream().filter(p -> this.isProgramPageExist(odfRootPage, (Program)p)).findFirst();
            return parentProgram.orElse(null);
        });
    }

    private Set<Program> _getParentPrograms(ProgramItem programItem, AbstractProgram parentProgram) {
        if (programItem instanceof Program) {
            Program program = (Program)programItem;
            return Set.of(program);
        }
        HashSet<Program> parentPrograms = new HashSet<Program>();
        AbstractProgram parent = parentProgram;
        List parentItems = this._odfHelper.getParentProgramItems(programItem, (ProgramPart)parentProgram);
        for (ProgramItem parentItem : parentItems) {
            if (parentItem instanceof Program) {
                Program program = (Program)parentItem;
                parentPrograms.add(program);
                continue;
            }
            if (parent != null && parentItem.equals((Object)parent)) {
                parent = null;
            }
            parentPrograms.addAll(this._getParentPrograms(parentItem, parent));
        }
        return parentPrograms;
    }

    public List<AbstractProgram> getNearestAncestorAbstractPrograms(ProgramPart programPart) {
        ArrayList<AbstractProgram> ancestors = new ArrayList<AbstractProgram>();
        List parents = programPart.getProgramPartParents();
        for (ProgramPart parent : parents) {
            if (parent instanceof AbstractProgram) {
                ancestors.add((AbstractProgram)parent);
                continue;
            }
            ancestors.addAll(this.getNearestAncestorAbstractPrograms(parent));
        }
        return ancestors;
    }

    public AbstractProgram getNearestAncestorAbstractProgram(ProgramItem programItem, AbstractProgram parentProgram) {
        ProgramItem parentItem = this._odfHelper.getParentProgramItem(programItem, parentProgram);
        while (parentItem != null && !(parentItem instanceof AbstractProgram)) {
            parentItem = this._odfHelper.getParentProgramItem(parentItem, parentProgram);
        }
        return parentItem != null ? (AbstractProgram)parentItem : null;
    }

    public Course getNearestAncestorCourse(Course course, AbstractProgram parentProgram) {
        ProgramItem parentItem = this._odfHelper.getParentProgramItem((ProgramItem)course, parentProgram);
        while (parentItem != null && !(parentItem instanceof Course) && !(parentItem instanceof AbstractProgram)) {
            parentItem = this._odfHelper.getParentProgramItem(parentItem, parentProgram);
        }
        return parentItem != null && parentItem instanceof Course ? (Course)parentItem : null;
    }

    public String getProgramItemPagePath(String siteName, String language, ProgramItem programItem, Program parentProgram) {
        Page rootPage = this._odfPageHandler.getOdfRootPage(siteName, language, programItem.getCatalog());
        if (rootPage != null) {
            AbstractProgramItemPage page = null;
            if (programItem instanceof Program) {
                Program program = (Program)programItem;
                page = this.getProgramPage(rootPage, program);
            } else if (programItem instanceof SubProgram) {
                SubProgram subProgram = (SubProgram)programItem;
                page = this.getSubProgramPage(rootPage, subProgram, (AbstractProgram)parentProgram);
            } else if (programItem instanceof Course) {
                Course course = (Course)programItem;
                page = this.getCoursePage(rootPage, course, (AbstractProgram)parentProgram);
            }
            if (page != null) {
                return rootPage.getSitemapName() + "/" + page.getPathInSitemap();
            }
        }
        return "";
    }

    private static class PathInProgramCacheKey
    extends AbstractCacheKey {
        protected PathInProgramCacheKey(String programItemId, String parentProgramId) {
            super(new Object[]{programItemId, parentProgramId});
        }

        public static PathInProgramCacheKey of(String programItemId, String parentProgramId) {
            return new PathInProgramCacheKey(programItemId, parentProgramId);
        }
    }

    private static class RootProgramCacheKey
    extends AbstractCacheKey {
        protected RootProgramCacheKey(Page odfRootPage, String programItemId, String parentProgramId) {
            super(new Object[]{odfRootPage, programItemId, parentProgramId});
        }

        public static RootProgramCacheKey of(Page odfRootPage, String programItemId, String parentProgramId) {
            return new RootProgramCacheKey(odfRootPage, programItemId, parentProgramId);
        }
    }
}

