/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

import org.ametys.odf.ProgramItem;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.runtime.plugin.component.DeferredServiceable;
import org.ametys.web.WebConstants;
import org.ametys.web.parameters.view.ViewParametersManager;
import org.ametys.web.repository.page.ZoneItem;

/**
 * Helper for ODF contents
 */
public class ODFHelper extends org.ametys.odf.ODFHelper implements DeferredServiceable
{
    private static final String __USE_LEGACY_PROGRAM_STRUCTURE_VIEW_PARAMETER = "useLegacyProgramStructure";
    
    private ViewParametersManager _viewParametersManager;

    @Override
    public void deferredService(ServiceManager manager) throws ServiceException
    {
        _viewParametersManager = (ViewParametersManager) manager.lookup(ViewParametersManager.ROLE);
    }
    
    @Override
    public boolean useLegacyProgramStructure(ProgramItem programItem)
    {
        Request request = ContextHelper.getRequest(_context);
        ZoneItem zoneItem = (ZoneItem) request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        
        if (zoneItem != null)
        {
            ModelAwareDataHolder contentViewParametersHolder = _viewParametersManager.getContentViewParametersHolder(zoneItem).orElse(null);
            if (contentViewParametersHolder != null && contentViewParametersHolder.hasDefinition(__USE_LEGACY_PROGRAM_STRUCTURE_VIEW_PARAMETER))
            {
                return contentViewParametersHolder.getValue(__USE_LEGACY_PROGRAM_STRUCTURE_VIEW_PARAMETER, true, true);
            }
        }
        
        return super.useLegacyProgramStructure(programItem);
    }
}
