/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.service.search;

import org.apache.cocoon.environment.Request;

import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.requesttime.AbstractSearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;

/**
 * This {@link SearchComponent} add a join query on acquired skill's id if present
 */
public abstract class AbstractSkillSearchComponent extends AbstractSearchComponent
{
    /** The parameter name for skill search field */
    protected static final String _SKILL_REQUEST_PARAM_NAME = "skillId";
    
    public boolean supports(SearchComponentArguments args)
    {
        SearchServiceInstance serviceInstance = args.serviceInstance();
        return _containsProgramReturnable(serviceInstance);
    }
    
    private boolean _containsProgramReturnable(SearchServiceInstance serviceInstance)
    {
        return serviceInstance.getReturnables()
                .stream()
                .map(Returnable::getId)
                .anyMatch(ProgramReturnable.ROLE::equals);
    }
    
    /**
     * Get the id of searched skill from the request
     * @param request the request
     * @return the id of searched skill
     */
    protected String _getSkillId(Request request)
    {
        return request.getParameter(_SKILL_REQUEST_PARAM_NAME);
    }
}
