/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.cart.ODFCartManager;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetSavedOdfCartItemsAction
extends ServiceableAction {
    private ODFCartManager _cartManager;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cartManager = (ODFCartManager)((Object)smanager.lookup(ODFCartManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        ArrayList items2json = new ArrayList();
        String siteName = WebHelper.getSiteName((Request)request);
        UserIdentity owner = this._currentUserProvider.getUser();
        if (owner != null) {
            try {
                List<ODFCartManager.ODFCartItem> items = this._cartManager.getCartItems(owner, siteName);
                for (ODFCartManager.ODFCartItem item : items) {
                    HashMap<String, String> item2json = new HashMap<String, String>();
                    item2json.put("id", item.getId());
                    Content content = item.getContent();
                    item2json.put("contentId", content.getId());
                    item2json.put("title", content.getTitle());
                    Program parentProgram = item.getParentProgram();
                    if (parentProgram != null) {
                        item2json.put("parentProgramId", parentProgram.getId());
                    }
                    items2json.add(item2json);
                }
            }
            catch (UserPreferencesException e) {
                this.getLogger().error("Failed to get cart items for current user " + String.valueOf(owner), (Throwable)e);
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("items", items2json);
        result.put("isAnonymous", Boolean.valueOf(owner == null));
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

