/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation.solr;

import java.util.Map;
import org.ametys.cms.content.indexing.solr.observation.ObserverHelper;
import org.ametys.core.observation.Event;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.restrictions.OdfProgramRestrictionManager;
import org.ametys.web.indexing.observation.AbstractSolrObserver;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.site.SiteConfigurationExtensionPoint;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractSolrOrgUnitObserver
extends AbstractSolrObserver
implements Contextualizable {
    protected SiteManager _siteManager;
    protected SiteConfigurationExtensionPoint _siteConf;
    protected OdfPageHandler _odfPageHandler;
    protected OdfProgramRestrictionManager _odfProgramRestrictionManager;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)serviceManager.lookup(OdfPageHandler.ROLE));
        this._siteConf = (SiteConfigurationExtensionPoint)serviceManager.lookup(SiteConfigurationExtensionPoint.ROLE);
        this._odfProgramRestrictionManager = (OdfProgramRestrictionManager)((Object)serviceManager.lookup(OdfProgramRestrictionManager.ROLE));
    }

    public boolean supports(Event event) {
        return event.getArguments().get("content") instanceof OrgUnit && ArrayUtils.contains((Object[])this._supportedEventIds(), (Object)event.getId());
    }

    protected abstract String[] _supportedEventIds();

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        if (ObserverHelper.isNotSuspendedObservationForIndexation()) {
            Request request = ContextHelper.getRequest((Context)this._context);
            request.setAttribute("odfweb.solr.indexing", (Object)true);
            for (Site site : this._siteManager.getSites()) {
                String siteName = site.getName();
                if (!this._odfPageHandler.hasOdfRootPage(site)) continue;
                for (Sitemap sitemap : site.getSitemaps()) {
                    for (Page odfRootPage : this._odfPageHandler.getOdfRootPages(siteName, sitemap.getSitemapName())) {
                        if (!this._odfProgramRestrictionManager.hasOrgunitRestrictions(odfRootPage) && !"orgUnit".equals(this._odfPageHandler.getLevel1Metadata(odfRootPage)) && !"orgUnit".equals(this._odfPageHandler.getLevel2Metadata(odfRootPage))) continue;
                        this._updateIndex(odfRootPage);
                    }
                }
            }
        }
    }

    protected abstract void _updateIndex(Page var1) throws Exception;
}

