/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfweb.repository.AbstractProgramItemPage;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.repository.ProgramPageFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ProgramPage
extends AbstractProgramItemPage<ProgramPageFactory> {
    private AbstractProgram _program;
    private String _path;
    private Page _parentPage;
    private Program _parentProgram;

    public ProgramPage(Page root, VirtualPageConfiguration configuration, ProgramPageFactory factory, AbstractProgram program, String path, Program parentProgram, Page parentPage) {
        super(root, configuration, factory.getScheme(), factory);
        this._program = program;
        this._path = path;
        this._parentPage = parentPage;
        this._parentProgram = parentProgram;
    }

    public AbstractProgram getProgram() {
        return this._program;
    }

    @Override
    protected ProgramItem getProgramItem() {
        return this.getProgram();
    }

    public int getDepth() throws AmetysRepositoryException {
        int levelDepth = 0;
        if (StringUtils.isNotBlank((CharSequence)((ProgramPageFactory)this._factory).getODFPageHandler().getLevel1Metadata(this._root))) {
            ++levelDepth;
            if (StringUtils.isNotBlank((CharSequence)((ProgramPageFactory)this._factory).getODFPageHandler().getLevel2Metadata(this._root))) {
                ++levelDepth;
            }
        }
        return this._root.getDepth() + levelDepth + (this._path != null ? this._path.split("/").length : 0);
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._program.getTitle();
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._program.getTitle();
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        List<Page> children = this._transformChildrenPages(this._traverseChildren((TraversableProgramPart)this._program)).toList();
        return new CollectionIterable(children);
    }

    private Page _createChildPage(ProgramItem child) {
        if (child instanceof SubProgram) {
            SubProgram subProgram = (SubProgram)child;
            return this._createChildProgramPage(subProgram);
        }
        if (child instanceof Course) {
            Course course = (Course)child;
            return this._createChildCoursePage(course);
        }
        return null;
    }

    private ProgramPage _createChildProgramPage(SubProgram child) {
        return ((ProgramPageFactory)this._factory).createProgramPage(this._root, (AbstractProgram)child, (String)(this._path != null ? this._path + "/" + this.getName() : this.getName()), this._getParentProgram(), (Page)this);
    }

    private CoursePage _createChildCoursePage(Course course) {
        return ((ProgramPageFactory)this._factory).getCoursePageFactory().createCoursePage(this._root, course, this._getParentProgram(), (String)(this._path != null ? this._path + "/" + this.getName() : this.getName()), (Page)this);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        String path = this._computePath(this._root.getPathInSitemap());
        return path == null ? null : path + "/" + this.getName();
    }

    private Program _getParentProgram() {
        return Optional.ofNullable(this._parentProgram).orElseGet(() -> (Program)this._program);
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        List<String> headQueuePath = Arrays.asList(StringUtils.split((String)path, (String)"/", (int)2));
        String name = headQueuePath.get(0);
        String queuePath = (String)Iterables.get(headQueuePath, (int)1, null);
        return (A)((AmetysObject)this._findChildPage((TraversableProgramPart)this._program, name).map(cp -> ((ProgramPageFactory)this._factory).getODFPageHandler().addRedirectIfNeeded((Page)cp, name)).map(cp -> ((ProgramPageFactory)this._factory).getODFPageHandler().exploreQueuePath((Page)cp, queuePath)).orElseThrow(() -> new UnknownAmetysObjectException("Unknown child page '" + path + "' for page " + this.getId())));
    }

    private Optional<Page> _findChildPage(TraversableProgramPart parent, String name) {
        return this._transformChildrenPages(this._traverseChildren(parent).filter(child -> this._filterByName((ProgramItem)child, name))).findFirst();
    }

    private boolean _filterByName(ProgramItem programItem, String name) {
        if (programItem.getCode().equals(name.substring(name.lastIndexOf("-") + 1))) {
            return true;
        }
        if (programItem instanceof SubProgram) {
            SubProgram subProgram = (SubProgram)programItem;
            String subProgramPageName = NameHelper.filterName((String)subProgram.getTitle()) + "-" + programItem.getName();
            return name.equals(subProgramPageName);
        }
        return false;
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return this._findChildPage((TraversableProgramPart)this._program, name).isPresent();
    }

    public String getId() throws AmetysRepositoryException {
        StringBuilder sb = new StringBuilder("program://");
        sb.append(StringUtils.isNotEmpty((CharSequence)this._path) ? this._path : "_root");
        sb.append("?rootId=").append(this._root.getId());
        sb.append("&programId=").append(this._program.getId());
        if (this._parentProgram != null) {
            sb.append("&parentId=").append(this._parentProgram.getId());
        }
        return sb.toString();
    }

    public String getName() throws AmetysRepositoryException {
        return ((ProgramPageFactory)this._factory).getODFPageHandler().getPageName((ProgramItem)this._program);
    }

    public Page getParent() throws AmetysRepositoryException {
        String childPath;
        if (this._parentPage == null && (childPath = this._computePath(null)) != null) {
            this._parentPage = childPath.isEmpty() ? this._root : (Page)this._root.getChild(childPath);
        }
        return this._parentPage;
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this._computePath(this._root.getPath());
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((ProgramPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }

    private Stream<ProgramItem> _traverseChildren(TraversableProgramPart parent) {
        Predicate<ProgramItem> isSubProgram = SubProgram.class::isInstance;
        Predicate<ProgramItem> isCourse = Course.class::isInstance;
        ProgramPartTraverser traverser = new ProgramPartTraverser(parent.getProgramPartChildren());
        return traverser.stream().filter(isSubProgram.or(isCourse)).distinct();
    }

    public AbstractProgram getContent() {
        AbstractProgram program = this.getProgram();
        program.setContextPath(this.getPathInSitemap());
        if (!((ProgramPageFactory)this._factory).isIndexing()) {
            this.setCurrentEducationalPaths((ProgramItem)program);
        }
        return program;
    }

    private String _computePath(String rootPath) {
        String levelsPath = ((ProgramPageFactory)this._factory).getODFPageHandler().computeLevelsPath(this._root, this._getParentProgram());
        if (levelsPath == null) {
            throw new UnknownAmetysObjectException("Page of program " + this._getParentProgram().getId() + " does not have a valid level path");
        }
        return Stream.of(rootPath, levelsPath, this._path).filter(StringUtils::isNotEmpty).collect(Collectors.joining("/"));
    }

    private Stream<Page> _transformChildrenPages(Stream<ProgramItem> children) {
        return children.map(this::_createChildPage).filter(Objects::nonNull).filter(page -> {
            try {
                page.getPathInSitemap();
                return true;
            }
            catch (UnknownAmetysObjectException e) {
                return false;
            }
        });
    }

    static class ProgramPartTraverser
    extends AbstractTreeIterator<ProgramItem> {
        public ProgramPartTraverser(Collection<? extends ProgramItem> programPartChildren) {
            super(programPartChildren);
        }

        @Override
        protected Iterator<ProgramItem> provideChildIterator(ProgramItem parent) {
            if (parent instanceof CourseList) {
                CourseList courseList = (CourseList)parent;
                return new ProgramPartTraverser(courseList.getCourses());
            }
            if (parent instanceof Container) {
                Container container = (Container)parent;
                return new ProgramPartTraverser(container.getProgramPartChildren());
            }
            return null;
        }
    }

    static abstract class AbstractTreeIterator<T>
    implements Iterator<T> {
        protected final Queue<Iterator<T>> _nodeIterators = new LinkedList<Iterator<T>>();
        private Boolean _hasNext;

        AbstractTreeIterator(Iterator<T> iterator) {
            if (iterator != null && iterator.hasNext()) {
                this._nodeIterators.add(iterator);
            }
        }

        AbstractTreeIterator(Collection<? extends T> children) {
            this(AbstractTreeIterator.handleConstructorChildren(children));
        }

        private static <T> Iterator<T> handleConstructorChildren(Collection<? extends T> children) {
            Collection<T> tChildren = Collections.unmodifiableCollection(children);
            return tChildren.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this._hasNext != null) {
                return this._hasNext;
            }
            Iterator<T> it = this._getOrUpdateHead();
            if (this._hasNext == null) {
                this._hasNext = it != null ? it.hasNext() : false;
            }
            return this._hasNext;
        }

        @Override
        public T next() {
            if (BooleanUtils.isFalse((Boolean)this._hasNext)) {
                throw new NoSuchElementException();
            }
            Iterator<T> it = null;
            it = this._hasNext == null ? this._getOrUpdateHead() : this._nodeIterators.peek();
            Object next = Optional.ofNullable(it).map(Iterator::next).orElseThrow(NoSuchElementException::new);
            Iterator<Object> childIterator = this.provideChildIterator(next);
            if (childIterator != null && childIterator.hasNext()) {
                this._nodeIterators.add(childIterator);
            }
            this._hasNext = null;
            return (T)next;
        }

        protected abstract Iterator<T> provideChildIterator(T var1);

        public Stream<T> stream() {
            Iterable iterable = () -> this;
            return StreamSupport.stream(iterable.spliterator(), false);
        }

        private Iterator<T> _getOrUpdateHead() {
            return Optional.ofNullable(this._nodeIterators.peek()).filter(it -> {
                if (it.hasNext()) {
                    this._hasNext = true;
                    return true;
                }
                return false;
            }).orElseGet(() -> this._updateHead());
        }

        private Iterator<T> _updateHead() {
            this._nodeIterators.poll();
            return this._nodeIterators.peek();
        }
    }
}

