<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                extension-element-prefixes="math">
    
    <xsl:import href="service:odf-web://pages/services/search/search_1.2.xsl"/>
    
 	<xsl:template name="hits">
        <div class="results">
            <ul>
                <xsl:for-each select="/search/hits/hit[not(content/domain/@id = preceding-sibling::*/content/domain/@id)]">
                	<xsl:sort select="domain" />
                	
                	<xsl:variable name="domain" select="content/domain/@id"/>
                	<li class="domain-group"><span><xsl:value-of select="content/domain/@title"/></span>     
	                	<ul class="custom program">
	                		<xsl:for-each select="../hit[content/domain/@id = $domain]">
								<li>
			                        <xsl:attribute name="class">hit page<xsl:text> </xsl:text>
			                            <xsl:call-template name="common-utils-class"/>                        
			                        </xsl:attribute> 
			                        <a title="{title}">
			                        	<xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
			                        	<xsl:value-of select="title"/>
			                        </a>
			                        
			                        <xsl:call-template name="hit-subprograms"/>
			                    </li>
							</xsl:for-each>
	                	</ul>
                	</li>     
                </xsl:for-each>                            
            </ul>
        </div>    
	</xsl:template>	    
            
</xsl:stylesheet>
