/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.tree.OdfClassificationHandler;
import org.ametys.plugins.odfweb.repository.AbstractOdfPage;
import org.ametys.plugins.odfweb.repository.FirstLevelPageFactory;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.odfweb.repository.SecondLevelPage;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang3.StringUtils;

public class FirstLevelPage
extends AbstractOdfPage<FirstLevelPageFactory> {
    private String _name;
    private String _title;

    public FirstLevelPage(Page root, VirtualPageConfiguration configuration, FirstLevelPageFactory factory, String name, String title) {
        super(root, configuration, factory.getScheme(), factory);
        this._name = name;
        this._title = title;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + 1;
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        if (!this._hasSecondLevelPages()) {
            List pages = this._getChildrenProgramPageFromCache().orElseGet(() -> ((FirstLevelPageFactory)this._factory).getODFPageHandler().getProgramsWithRestrictions(this._root, this._name, null, null, null)).stream().map(this::_createProgramPage).collect(Collectors.toList());
            return new CollectionIterable(pages);
        }
        Map secondLevelCache = Optional.ofNullable(((FirstLevelPageFactory)this._factory).getODFPageCache().getProgramCache(this._root, true).get(this._name)).orElseGet(HashMap::new);
        Map<String, OdfClassificationHandler.LevelValue> secondLevelValues = ((FirstLevelPageFactory)this._factory).getODFPageHandler().getLevel2Values(this._root);
        List children = secondLevelCache.keySet().stream().map(secondLevelCode -> this._findSecondLevelValueEntry(secondLevelValues, (String)secondLevelCode).orElse(null)).filter(Objects::nonNull).map(entry -> this._createSecondLevelPage((Map.Entry<String, OdfClassificationHandler.LevelValue>)entry)).collect(Collectors.toList());
        return new CollectionIterable(children);
    }

    private boolean _hasSecondLevelPages() {
        String level2Metadata = ((FirstLevelPageFactory)this._factory).getODFPageHandler().getLevel2Metadata(this._root);
        return StringUtils.isNotBlank((CharSequence)level2Metadata);
    }

    private Optional<AmetysObjectIterable<Program>> _getChildrenProgramPageFromCache() {
        return ((FirstLevelPageFactory)this._factory).getODFPageCache().getPrograms(this._root, this._name, null, false);
    }

    private Optional<Map.Entry<String, OdfClassificationHandler.LevelValue>> _findSecondLevelValueEntry(String levelCode) {
        Map<String, OdfClassificationHandler.LevelValue> secondLevelValues = ((FirstLevelPageFactory)this._factory).getODFPageHandler().getLevel2Values(this._root);
        return this._findSecondLevelValueEntry(secondLevelValues, levelCode);
    }

    private Optional<Map.Entry<String, OdfClassificationHandler.LevelValue>> _findSecondLevelValueEntry(Map<String, OdfClassificationHandler.LevelValue> secondLevelValues, String levelCode) {
        return secondLevelValues.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(levelCode)).findFirst();
    }

    private SecondLevelPage _createSecondLevelPage(Map.Entry<String, OdfClassificationHandler.LevelValue> secondLevelValueEntry) {
        String childName = secondLevelValueEntry.getKey();
        String title = secondLevelValueEntry.getValue().getValue();
        return ((FirstLevelPageFactory)this._factory).getSecondLevelPageFactory().createSecondLevelPage(this._root, this._name, childName, title, this);
    }

    private ProgramPage _createProgramPage(Program program) {
        return ((FirstLevelPageFactory)this._factory).getProgramPageFactory().createProgramPage(this._root, (AbstractProgram)program, null, null, (Page)this);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        return this._root.getPathInSitemap() + "/" + this.getName();
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        if (!this._hasSecondLevelPages()) {
            return (A)((FirstLevelPageFactory)this._factory).getODFPageCache().getChildProgramPage(this._root, (Page)this, this._name, null, path);
        }
        int i = path.indexOf(47);
        String name = i == -1 ? path : path.substring(0, path.indexOf(47));
        int index = name.lastIndexOf("-");
        String level2Code = index != -1 ? ((FirstLevelPageFactory)this._factory).getODFPageHandler().decodeLevelValue(name.substring(index + 1)) : ((FirstLevelPageFactory)this._factory).getODFPageHandler().decodeLevelValue(name);
        String queuePath = i == -1 ? null : path.substring(i + 1);
        return (A)((AmetysObject)this._findSecondLevelValueEntry(level2Code).map(this::_createSecondLevelPage).map(cp -> ((FirstLevelPageFactory)this._factory).getODFPageHandler().addRedirectIfNeeded((Page)cp, name)).map(cp -> ((FirstLevelPageFactory)this._factory).getODFPageHandler().exploreQueuePath((Page)cp, queuePath)).orElseThrow(() -> new UnknownAmetysObjectException("Unknown child page '" + path + "' for page " + this._name)));
    }

    @Override
    public AmetysObjectIterable<? extends Page> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String childName) throws AmetysRepositoryException {
        if (!this._hasSecondLevelPages()) {
            return ((FirstLevelPageFactory)this._factory).getODFPageCache().getProgramFromPageName(this._root, this._name, null, childName).isPresent();
        }
        Map<String, OdfClassificationHandler.LevelValue> secondLevelValues = ((FirstLevelPageFactory)this._factory).getODFPageHandler().getLevel2Values(this._root);
        return secondLevelValues.containsKey(childName);
    }

    public String getId() throws AmetysRepositoryException {
        return "odfLevel1://" + ((FirstLevelPageFactory)this._factory).getODFPageHandler().encodeLevelValue(this._name) + "?rootId=" + this._root.getId();
    }

    public String getName() throws AmetysRepositoryException {
        return NameHelper.filterName((String)this._title) + "-" + ((FirstLevelPageFactory)this._factory).getODFPageHandler().encodeLevelValue(this._name);
    }

    public Page getParent() throws AmetysRepositoryException {
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this._root.getPath();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((FirstLevelPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }
}

