/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.tree.OdfClassificationHandler;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.ProgramPageFactory;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.provider.WorkspaceSelector;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ODFPageCache
extends AbstractLogEnabled
implements Serviceable,
Initializable,
Component {
    public static final String ROLE = ODFPageCache.class.getName();
    private static final String __NO_FIRST_DATA_KEY = "_no-first-data";
    private static final String __NO_SECOND_DATA_KEY = "_no-second-data";
    private static final String __TREE_CACHE = ODFPageCache.class.getName() + "$tree";
    private static final String __PROGRAM_CACHE = ODFPageCache.class.getName() + "$program";
    private static final String __INDEXABLE_CACHE = ODFPageCache.class.getName() + "$indexable";
    private OdfPageHandler _odfPageHandler;
    private WorkspaceSelector _workspaceSelector;
    private AmetysObjectResolver _resolver;
    private AmetysObjectFactoryExtensionPoint _ametysObjectFactoryEP;
    private AbstractCacheManager _cacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
        this._workspaceSelector = (WorkspaceSelector)manager.lookup(WorkspaceSelector.ROLE);
        this._ametysObjectFactoryEP = (AmetysObjectFactoryExtensionPoint)manager.lookup(AmetysObjectFactoryExtensionPoint.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(__TREE_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ODF_PAGE_TREE_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ODF_PAGE_TREE_DESCRIPTION"), false);
        this._cacheManager.createRequestCache(__PROGRAM_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ODF_PAGE_PROGRAM_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ODF_PAGE_PROGRAM_DESCRIPTION"), false);
        this._cacheManager.createRequestCache(__INDEXABLE_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ODF_ROOT_INDEXABLE_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ODF_ROOT_INDEXABLE_DESCRIPTION"), false);
    }

    Map<String, Map<String, Collection<Program>>> getProgramCache(Page rootPage, boolean computeIfNotPresent) {
        String workspace = this._workspaceSelector.getWorkspace();
        String pageId = rootPage.getId();
        Cache<ODFPageCacheKey, Map<String, Map<String, Collection<Program>>>> odfPageCache = this._getODFPageCache();
        TreeMap<String, Map> level1Tree = (TreeMap<String, Map>)odfPageCache.get((Object)ODFPageCacheKey.of(workspace, pageId));
        if (level1Tree == null) {
            if (!computeIfNotPresent) {
                return null;
            }
            Map<String, OdfClassificationHandler.LevelValue> level1Values = this._odfPageHandler.getLevel1Values(rootPage);
            Set<String> level1Codes = level1Values.keySet();
            LevelComparator level1Comparator = new LevelComparator(level1Values);
            Map<String, OdfClassificationHandler.LevelValue> level2Values = this._odfPageHandler.getLevel2Values(rootPage);
            Set<String> level2Codes = level2Values.keySet();
            LevelComparator level2Comparator = new LevelComparator(level2Values);
            level1Tree = new TreeMap<String, Map>(level1Comparator);
            odfPageCache.put((Object)ODFPageCacheKey.of(workspace, pageId), level1Tree);
            AmetysObjectIterable<Program> programs = this._odfPageHandler.getProgramsWithRestrictions(rootPage, null, null, null, null);
            String level1MetaPath = this._odfPageHandler.getLevel1Metadata(rootPage);
            String level2MetaPath = this._odfPageHandler.getLevel2Metadata(rootPage);
            for (Program program : programs) {
                String programL1Value;
                if (StringUtils.isBlank((CharSequence)level1MetaPath)) {
                    Map level2Tree = level1Tree.computeIfAbsent(__NO_FIRST_DATA_KEY, x -> new TreeMap(level2Comparator));
                    Collection programCache = level2Tree.computeIfAbsent(__NO_SECOND_DATA_KEY, x -> new ArrayList());
                    programCache.add(program);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)level2MetaPath)) {
                    programL1Value = this._odfPageHandler.getProgramLevelValue(program, level1MetaPath);
                    if (!level1Codes.contains(programL1Value)) continue;
                    Map level2Tree = level1Tree.computeIfAbsent(programL1Value, x -> new TreeMap(level2Comparator));
                    Collection programCache = level2Tree.computeIfAbsent(__NO_SECOND_DATA_KEY, x -> new ArrayList());
                    programCache.add(program);
                    continue;
                }
                programL1Value = this._odfPageHandler.getProgramLevelValue(program, level1MetaPath);
                String programL2Value = this._odfPageHandler.getProgramLevelValue(program, level2MetaPath);
                if (!level1Codes.contains(programL1Value) || !level2Codes.contains(programL2Value)) continue;
                Map level2Tree = level1Tree.computeIfAbsent(programL1Value, x -> new TreeMap(level2Comparator));
                Collection programCache = level2Tree.computeIfAbsent(programL2Value, x -> new ArrayList());
                programCache.add(program);
            }
        }
        return level1Tree;
    }

    boolean areChildrenIndexable(Page rootPage) {
        return (Boolean)this._getODFRootIndexablePageCache().get((Object)rootPage.getId(), __ -> (Boolean)rootPage.getValue("indexableChildren", (Object)true));
    }

    Optional<AmetysObjectIterable<Program>> getPrograms(Page rootPage, String level1, String level2, boolean computeIfNotPresent) {
        return Optional.ofNullable(this.getProgramCache(rootPage, computeIfNotPresent)).map(firstLevelCache -> (Map)firstLevelCache.get(Optional.ofNullable(level1).orElse(__NO_FIRST_DATA_KEY))).map(secondLevelCache -> (Collection)secondLevelCache.get(Optional.ofNullable(level2).orElse(__NO_SECOND_DATA_KEY))).map(CollectionIterable::new);
    }

    Page getChildProgramPage(Page rootPage, Page parentPage, String level1, String level2, String path) throws UnknownAmetysObjectException {
        List<String> headQueuePath = Arrays.asList(StringUtils.split((String)path, (String)"/", (int)2));
        String queuePath = (String)Iterables.get(headQueuePath, (int)1, null);
        String pageName = headQueuePath.get(0);
        ProgramPageFactory programPageFactory = (ProgramPageFactory)((Object)this._ametysObjectFactoryEP.getExtension(ProgramPageFactory.class.getName()));
        return this.getProgramFromPageName(rootPage, level1, level2, pageName).map(program -> programPageFactory.createProgramPage(rootPage, (AbstractProgram)program, null, null, parentPage)).map(cp -> this._odfPageHandler.addRedirectIfNeeded((Page)cp, pageName)).map(cp -> this._odfPageHandler.exploreQueuePath((Page)cp, queuePath)).orElseThrow(() -> new UnknownAmetysObjectException("There's no program for page's name " + pageName));
    }

    Optional<Program> getProgramFromPageName(Page rootPage, String level1, String level2, String pageName) {
        String name;
        String programName = null;
        String programCode = null;
        int j = pageName.lastIndexOf("program-");
        if (j != -1 && this._doesProgramNameExist(rootPage, name = pageName.substring(j))) {
            programName = name;
        }
        if (programName == null) {
            j = pageName.lastIndexOf("-");
            programCode = j == -1 ? pageName : pageName.substring(j + 1);
        }
        return Optional.ofNullable(this.getProgram(rootPage, level1, level2, programCode, programName));
    }

    private boolean _doesProgramNameExist(Page rootPage, String programName) {
        String xPathQuery;
        AmetysObjectIterable programs;
        String catalog = this._odfPageHandler.getCatalog(rootPage);
        String lang = rootPage.getSitemapName();
        AndExpression expression = new AndExpression(new Expression[0]);
        expression.add((Object)new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.program"}));
        expression.add((Object)new LanguageExpression(Expression.Operator.EQ, lang));
        if (catalog != null) {
            expression.add((Object)new StringExpression("catalog", Expression.Operator.EQ, catalog));
        }
        return (programs = this._resolver.query(xPathQuery = QueryHelper.getXPathQuery((String)programName, (String)"ametys:content", (Expression)expression))).getSize() > 0L;
    }

    Program getProgram(Page rootPage, String level1, String level2, String programCode, String programName) {
        String workspace = this._workspaceSelector.getWorkspace();
        String pageId = rootPage.getId();
        Cache<ODFPageProgramCacheKey, Program> odfPageCache = this._getODFPageProgramCache();
        String level1Key = Objects.toString(level1, __NO_FIRST_DATA_KEY);
        String level2Key = Objects.toString(level2, __NO_SECOND_DATA_KEY);
        String programKey = Objects.toString(programCode, programName);
        return (Program)odfPageCache.get((Object)ODFPageProgramCacheKey.of(workspace, pageId, level1Key, level2Key, programKey), key -> this._getProgramWithRestrictions(rootPage, level1, level2, programCode, programName));
    }

    private Program _getProgramWithRestrictions(Page rootPage, String level1, String level2, String programCode, String programName) {
        return this._odfPageHandler.getProgramsWithRestrictions(rootPage, level1, level2, programCode, programName).stream().findFirst().orElse(null);
    }

    public void clearCache(Page rootPage) {
        this._getODFPageCache().invalidate((Object)ODFPageCacheKey.of(null, rootPage.getId()));
        this._getODFPageProgramCache().invalidate((Object)ODFPageProgramCacheKey.of(null, rootPage.getId(), null, null, null));
        this._getODFRootIndexablePageCache().invalidate((Object)rootPage.getId());
    }

    private Cache<ODFPageCacheKey, Map<String, Map<String, Collection<Program>>>> _getODFPageCache() {
        return this._cacheManager.get(__TREE_CACHE);
    }

    private Cache<ODFPageProgramCacheKey, Program> _getODFPageProgramCache() {
        return this._cacheManager.get(__PROGRAM_CACHE);
    }

    private Cache<String, Boolean> _getODFRootIndexablePageCache() {
        return this._cacheManager.get(__INDEXABLE_CACHE);
    }

    private static class ODFPageCacheKey
    extends AbstractCacheKey {
        public ODFPageCacheKey(String workspace, String pageId) {
            super(new Object[]{workspace, pageId});
        }

        public static ODFPageCacheKey of(String workspace, String pageId) {
            return new ODFPageCacheKey(workspace, pageId);
        }
    }

    private static class LevelComparator
    implements Comparator<String> {
        private final Map<String, OdfClassificationHandler.LevelValue> _levelValues;

        public LevelComparator(Map<String, OdfClassificationHandler.LevelValue> initialMap) {
            this._levelValues = initialMap;
        }

        @Override
        public int compare(String s1, String s2) {
            if (this._levelValues.containsKey(s1)) {
                return this._levelValues.get(s1).compareTo(this._levelValues.get(s2));
            }
            return 0;
        }
    }

    private static class ODFPageProgramCacheKey
    extends AbstractCacheKey {
        public ODFPageProgramCacheKey(String workspace, String pageId, String level1Value, String level2Value, String programName) {
            super(new Object[]{workspace, pageId, level1Value, level2Value, programName});
        }

        public static ODFPageProgramCacheKey of(String workspace, String pageId, String level1Value, String level2Value, String programName) {
            return new ODFPageProgramCacheKey(workspace, pageId, level1Value, level2Value, programName);
        }
    }
}

