/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.workflow;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;

/**
 * OS workflow function to send mail after an action is triggered on ODF contents
 */
public class SendMailFunction extends org.ametys.web.workflow.SendMailFunction
{
    private OdfPageResolver _odfPageResolver;
    private SiteManager _siteManager;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _odfPageResolver = (OdfPageResolver) manager.lookup(OdfPageResolver.ROLE);
        _siteManager = (SiteManager) manager.lookup(SiteManager.ROLE);
    }
    
    @Override
    protected Site _getSite(WorkflowAwareContent content)
    {
        Site site = super._getSite(content);
        if (site == null)
        {
            String siteName = (String) _getRequest().getAttribute("siteName");
            if (siteName != null)
            {
                site = _siteManager.getSite(siteName);
            }
        }
        return site;
    }
    
    @Override
    protected Page _getPage(WorkflowAwareContent content, Site site)
    {
        if (content instanceof Program)
        {
            return _odfPageResolver.getProgramPage((Program) content, site.getName());
        }
        else if (content instanceof AbstractProgram)
        {
            return _odfPageResolver.getSubProgramPage((SubProgram) content, null, site.getName());
        }
        else if (content instanceof Course)
        {
            return _odfPageResolver.getCoursePage((Course) content, (AbstractProgram) null, site.getName());
        }
        else
        {
            return super._getPage(content, site);
        }
    } 
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_SEND_MAIL_FUNCTION_LABEL");
    }
}
