/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cachepolicy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.observation.Event;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.pageelement.PageElementCachePolicy;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class OdfProgramListServiceCachePolicy
extends AbstractLogEnabled
implements Serviceable,
PageElementCachePolicy {
    private static final Set<String> _TYPES = new HashSet<String>();
    protected OdfPageHandler _odfRootPageHandler;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfRootPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
    }

    public Set<String> getPageElementTypes() {
        return _TYPES;
    }

    public final PageElementCachePolicy.PolicyResult shouldClearCache(String workspace, Site site, String pageElementType, Event event) {
        String id = event.getId();
        if (this._getRemovingCacheEventIds(workspace).contains(id)) {
            Page page2;
            Page page1;
            Object object;
            Map args = event.getArguments();
            if (args.containsKey("content") && ((object = args.get("content")) instanceof Program || object instanceof OrgUnit) && this._odfRootPageHandler.hasOdfRootPage(site)) {
                return PageElementCachePolicy.PolicyResult.REMOVE;
            }
            Object v = args.get("page");
            if (v instanceof Page && this._odfRootPageHandler.isODFRootPage(page1 = (Page)v) || (v = args.get("sitemapelement")) instanceof Page && this._odfRootPageHandler.isODFRootPage(page2 = (Page)v)) {
                return PageElementCachePolicy.PolicyResult.REMOVE;
            }
        }
        return PageElementCachePolicy.PolicyResult.KEEP;
    }

    public final PageElementCachePolicy.PolicyResult shouldClearCache(String workspace, Site site, String pageElementType, String elementId, Event event) {
        throw new UnsupportedOperationException("Should never be called.");
    }

    protected List<String> _getRemovingCacheEventIds(String workspace) {
        if ("default".equals(workspace)) {
            return Arrays.asList("content.added", "content.modified", "content.deleting", "odf.root.updated", "odf.root.deleted");
        }
        if ("live".equals(workspace)) {
            return Arrays.asList("content.added", "content.validated", "content.deleting", "odf.root.updated", "odf.root.deleted");
        }
        return Collections.emptyList();
    }

    static {
        _TYPES.add("SERVICE:org.ametys.odf.service.ProgramList");
    }
}

