/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.repository;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.odf.ODFHelper;
import org.ametys.plugins.odfweb.observation.solr.AbstractSolrODFObserver;
import org.ametys.web.data.type.ModelItemTypeExtensionPoint;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;

/**
 * Common class for factories of ODF virtual pages
 */
public abstract class AbstractOdfPageFactory extends AbstractConfigurableVirtualPageFactory
{
    /** The odf page handler */
    protected OdfPageHandler _odfPageHandler;
    /** The odf page cache */
    protected ODFPageCache _pageCache;
    /** The ODF helper */
    protected ODFHelper _odfHelper;

    @Override
    public void deferredService(ServiceManager manager) throws ServiceException
    {
        super.deferredService(manager);
        
        _odfHelper = (ODFHelper) manager.lookup(ODFHelper.ROLE);
        _odfPageHandler = (OdfPageHandler) manager.lookup(OdfPageHandler.ROLE);
        _pageCache = (ODFPageCache) manager.lookup(ODFPageCache.ROLE);
    }
    
    ODFPageCache getODFPageCache()
    {
        return _pageCache;
    }
    
    OdfPageHandler getODFPageHandler()
    {
        return _odfPageHandler;
    }
    
    ModelItemTypeExtensionPoint getZoneDataTypeEP()
    {
        return _pageDataTypeExtensionPoint;
    }
    
    ModelItemTypeExtensionPoint getZoneItemDataTypeEP()
    {
        return _pageDataTypeExtensionPoint;
    }
    
    FirstLevelPageFactory getFirstLevelPageFactory()
    {
        return (FirstLevelPageFactory) _ametysObjectFactoryEP.getExtension(FirstLevelPageFactory.class.getName());
    }
    
    SecondLevelPageFactory getSecondLevelPageFactory()
    {
        return (SecondLevelPageFactory) _ametysObjectFactoryEP.getExtension(SecondLevelPageFactory.class.getName());
    }
    
    ProgramPageFactory getProgramPageFactory()
    {
        return (ProgramPageFactory) _ametysObjectFactoryEP.getExtension(ProgramPageFactory.class.getName());
    }
    
    CoursePageFactory getCoursePageFactory()
    {
        return (CoursePageFactory) _ametysObjectFactoryEP.getExtension(CoursePageFactory.class.getName());
    }
    
    boolean isIndexing()
    {
        Boolean indexing = (Boolean) getRequest().getAttribute(AbstractSolrODFObserver.REQUEST_ATTRIBUTE_INDEXING);
        return indexing != null && indexing.booleanValue();
    }
}
