/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.restrictions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.model.ContentElementDefinition;
import org.ametys.core.ui.Callable;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.plugins.odfweb.restrictions.OdfProgramRestriction;
import org.ametys.plugins.odfweb.restrictions.rules.OdfAndRestrictionRule;
import org.ametys.plugins.odfweb.restrictions.rules.OdfAttributeRestrictionRule;
import org.ametys.plugins.odfweb.restrictions.rules.OdfNotRestrictionRule;
import org.ametys.plugins.odfweb.restrictions.rules.OdfOrRestrictionRule;
import org.ametys.plugins.odfweb.restrictions.rules.OdfOrgunitRestrictionRule;
import org.ametys.plugins.odfweb.restrictions.rules.OdfRestrictionRule;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;

public class OdfProgramRestrictionManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
Disposable {
    public static final String ROLE = OdfProgramRestrictionManager.class.getName();
    protected SiteManager _siteManager;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected AmetysObjectResolver _resolver;
    protected OdfReferenceTableHelper _odfReferenceTableHelper;
    protected RootOrgUnitProvider _rootOrgUnitProvider;
    protected Context _cocoonContext;
    protected Map<String, OdfProgramRestriction> _restrictions;
    private org.apache.avalon.framework.context.Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._rootOrgUnitProvider = (RootOrgUnitProvider)serviceManager.lookup(RootOrgUnitProvider.ROLE);
        this._odfReferenceTableHelper = (OdfReferenceTableHelper)serviceManager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void dispose() {
        this._restrictions = null;
    }

    public Map<String, OdfProgramRestriction> getRestrictions() {
        if (this._restrictions == null) {
            this._readRestrictionConfigurationFile();
        }
        return this._restrictions;
    }

    public OdfProgramRestriction getRestriction(Page odfRootPage) {
        Site site = odfRootPage.getSite();
        String restrictionId = (String)site.getValue("odf-restrictions");
        if (StringUtils.isNotEmpty((String)restrictionId)) {
            return this.getRestrictions().get(restrictionId);
        }
        return null;
    }

    public boolean hasRestrictions(Page rootPage) {
        Site site = rootPage.getSite();
        String restrictionId = (String)site.getValue("odf-restrictions");
        return StringUtils.isNotEmpty((String)restrictionId) ? this.getRestrictions().containsKey(restrictionId) : false;
    }

    public boolean hasOrgunitRestrictions(Page rootPage) {
        Site site = rootPage.getSite();
        String restrictionId = (String)site.getValue("odf-restrictions");
        if (StringUtils.isNotEmpty((String)restrictionId)) {
            OdfProgramRestriction odfProgramRestriction = this.getRestrictions().get(restrictionId);
            return odfProgramRestriction.hasOrgunitRestrictions();
        }
        return false;
    }

    @Callable(rights={"*"})
    public String getRestrictionRootOrgUnitId(String siteName) {
        OdfProgramRestriction odfProgramRestriction;
        String odfRootId = null;
        Site site = this._siteManager.getSite(siteName);
        String restrictionId = (String)site.getValue("odf-restrictions");
        if (StringUtils.isNotEmpty((String)restrictionId) && (odfProgramRestriction = this.getRestrictions().get(restrictionId)) != null && odfProgramRestriction.hasOrgunitRestrictions()) {
            odfRootId = odfProgramRestriction.getId();
        }
        if (StringUtils.isBlank(odfRootId)) {
            odfRootId = this._rootOrgUnitProvider.getRootId();
        }
        return odfRootId;
    }

    protected void _readRestrictionConfigurationFile() {
        this._restrictions = new HashMap<String, OdfProgramRestriction>();
        File restrictionFile = new File(this._cocoonContext.getRealPath("/WEB-INF/param/odf-restrictions.xml"));
        if (restrictionFile.exists()) {
            try (FileInputStream is = new FileInputStream(restrictionFile);){
                Configuration[] restrictionConfs;
                Configuration cfg = new DefaultConfigurationBuilder().build((InputStream)is);
                for (Configuration restrictionConf : restrictionConfs = cfg.getChildren("restriction")) {
                    String id = restrictionConf.getAttribute("id");
                    I18nizableText label = this._configureI18nizableText(restrictionConf, "label", "", "application");
                    List<OdfRestrictionRule> rules = this._configureRestrictionRules(restrictionConf.getChild("rules"));
                    this._restrictions.put(id, new OdfProgramRestriction(id, label, rules));
                }
                Configuration orgunitConf = cfg.getChild("orgunits", false);
                if (orgunitConf != null) {
                    this._addDefaultOrgunitRestrictions();
                }
            }
            catch (Exception e) {
                this.getLogger().error("Cannot read the configuration file located at /WEB-INF/param/odf-restrictions.xml. Reverting to default.", (Throwable)e);
                this._restrictions.clear();
                this._addDefaultOrgunitRestrictions();
            }
        } else {
            this._addDefaultOrgunitRestrictions();
        }
    }

    private I18nizableText _configureI18nizableText(Configuration config, String name, String defaultValue, String defaultCatalog) {
        Configuration textConfig = config.getChild(name);
        boolean i18nSupported = textConfig.getAttributeAsBoolean("i18n", false);
        String text = textConfig.getValue(defaultValue);
        if (i18nSupported) {
            String catalogue = textConfig.getAttribute("catalogue", defaultCatalog);
            return new I18nizableText(catalogue, text);
        }
        return new I18nizableText(text);
    }

    protected List<OdfRestrictionRule> _configureRestrictionRules(Configuration rulesConf) throws ConfigurationException {
        ArrayList<OdfRestrictionRule> rules = new ArrayList<OdfRestrictionRule>();
        for (Configuration ruleConf : rulesConf.getChildren()) {
            rules.add(this._configureRestrictionRule(ruleConf));
        }
        return rules;
    }

    protected OdfRestrictionRule _configureRestrictionRule(Configuration ruleConf) throws ConfigurationException {
        String name = ruleConf.getName();
        if ("item".equals(name)) {
            String attributePath = ruleConf.getAttribute("ref");
            String attributeValue = ruleConf.getAttribute("value");
            ContentType programContentType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.odf.Content.program");
            if (programContentType.hasModelItem(attributePath)) {
                OdfReferenceTableEntry itemFromCode;
                ContentElementDefinition def;
                ModelItem modelItem = programContentType.getModelItem(attributePath);
                if (modelItem instanceof ContentElementDefinition && this._odfReferenceTableHelper.isTableReference((def = (ContentElementDefinition)modelItem).getContentTypeId()) && (itemFromCode = this._odfReferenceTableHelper.getItemFromCode(def.getContentTypeId(), attributeValue)) != null) {
                    return new OdfAttributeRestrictionRule(attributePath, itemFromCode.getId());
                }
                return new OdfAttributeRestrictionRule(attributePath, attributeValue);
            }
            throw new ConfigurationException("Attribute path '" + attributePath + "' is unknown for program content type.");
        }
        if ("orgunit".equals(name)) {
            String orgunitId = ruleConf.getAttribute("id", null);
            if (StringUtils.isEmpty((String)orgunitId)) {
                throw new ConfigurationException("Expecting 'id' attribute for orgunit restriction rule.");
            }
            return new OdfOrgunitRestrictionRule(this._rootOrgUnitProvider, orgunitId);
        }
        if ("and".equals(name)) {
            List<OdfRestrictionRule> childRules = this._configureRestrictionRules(ruleConf);
            return new OdfAndRestrictionRule(childRules);
        }
        if ("or".equals(name)) {
            List<OdfRestrictionRule> childRules = this._configureRestrictionRules(ruleConf);
            return new OdfOrRestrictionRule(childRules);
        }
        if ("not".equals(name)) {
            List<OdfRestrictionRule> childRules = this._configureRestrictionRules(ruleConf);
            return new OdfNotRestrictionRule(childRules);
        }
        throw new ConfigurationException("Unknow node name in restriction configuration : " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addDefaultOrgunitRestrictions() {
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, null);
            String rootOrgunitId = this._rootOrgUnitProvider.getRootId();
            Set orgunitIds = this._rootOrgUnitProvider.getChildOrgUnitIds(rootOrgunitId, true);
            orgunitIds.add(rootOrgunitId);
            for (String id : orgunitIds) {
                if (StringUtils.equals((String)id, (String)rootOrgunitId)) continue;
                OrgUnit orgunit = (OrgUnit)this._resolver.resolveById(id);
                OdfOrgunitRestrictionRule rule = new OdfOrgunitRestrictionRule(this._rootOrgUnitProvider, id);
                OdfProgramRestriction restriction = new OdfProgramRestriction(id, new I18nizableText(orgunit.getTitle()), Collections.singletonList(rule));
                this._restrictions.put(id, restriction);
            }
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }
}

