/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This singleton class contains the overloads for ODF web export
 * @private
 */
Ext.define('Ametys.plugins.odf.web.export.Export', {
    singleton: true,
    
    /**
     * Exports the catalog in InDesign format.
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    exportInDesignCatalog: function(controller)
    {
        Ametys.plugins.odf.indesign.ExportCatalogInDesign.open(this._doCatalogExport);
    },
    
    /**
     * @private
     * Do export
     * @param {Object} values The selected values
     * @param {String} values.catalog The selected catalog
     * @param {String} values.xslt The XSLT file for unit export
     * @param {String} values.globalXslt The XSLT file for global export
     */
    _doCatalogExport: function(values)
    {
        Ametys.openWindow(Ametys.getPluginDirectPrefix('odf-web') + '/' + Ametys.getAppParameter('siteName') + '/indesign/' + values.catalog + '/catalogue.xml', values);
    },
    
    /**
     * Exports a program in InDesign format.
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    exportInDesign: function(controller)
    {
        var target = controller.getMatchingTargets()[0];
        var programId = target.getParameters().id;
        
        Ametys.plugins.odf.indesign.ExportInDesign.open(programId, this._doExport);
    },
    
    /**
     * @private
     * Do export
     * @param {Object} values The selected values :
     * @param {String} values.id The id of program to export
     * @param {String} values.xslt The XSLT file for unit export
     */
    _doExport: function (values)
    {
        var params = Ext.applyIf(values, Ametys.getAppParameters());
        Ametys.openWindow(Ametys.getPluginDirectPrefix('odf-web') + '/' + Ametys.getAppParameter('siteName') + '/indesign/program.xml', values);
    }
});