<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="exslt">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>

    <xsl:param name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:param name="firstLevel" select="normalize-space(ametys:serviceParameter('firstLevel')/text())"/>
    <xsl:param name="secondLevel" select="normalize-space(ametys:serviceParameter('secondLevel')/text())"/>
    <xsl:param name="displaySubProgram" select="ametys:serviceParameter('displaySubProgram')/text()"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">odf-programs-list by-degree</xsl:variable>
    <xsl:variable name="is-empty" select="not(/xml)"/>    
    <xsl:variable name="common-service-name">service-odf-programs-list-by-degree</xsl:variable> 
    
    <xsl:variable name="id" select="concat('programlistbydegree_', substring-after(math:random(), '.'))"/>

    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>        
        </xsl:call-template>
    </xsl:template>   
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('web', 'js/jquery.treeview.min.js')}"></script>
        
        <script type="text/javascript">
            $j(document).ready(function(){
                $j('#<xsl:value-of select="$id"/>').treeview({ collapsed: true });
            });
        </script>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="programs-list"/>
    </xsl:template>
    
    <xsl:template name="programs-list">
        <xsl:choose>
            <xsl:when test="$secondLevel = ''">
                <!-- Dispatch programs on one level only -->
                <xsl:call-template name="programs-list-one-level"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Dispatch programs on two levels  -->
                <xsl:call-template name="programs-list-two-levels"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="programs-list-one-level">
        <!-- Program refs node set-->
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <program-ref refid="{$refid}" />
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        
        <xsl:if test="$firstLevelItems[1]">
            <ul id="{$id}">
                <xsl:apply-templates select="$firstLevelItems" mode="one-level">
                    <xsl:with-param name="program-refs" select="$program-refs"/>
                </xsl:apply-templates>
            </ul>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="programs-list-two-levels">
        <!-- Program refs node set-->
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '' and metadata[@path = $secondLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <xsl:for-each select="../../metadata[@path = $secondLevel]/value">
                                <second value="{.}">
                                    <program-ref refid="{$refid}" />
                                </second>
                            </xsl:for-each>
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        <xsl:variable name="secondLevelItems" select="/xml/items[@metadataPath = $secondLevel]/item" />
    
        <xsl:if test="$firstLevelItems[1] and $secondLevelItems[1]">
            <ul id="{$id}">
                <xsl:apply-templates select="$firstLevelItems">
                    <xsl:with-param name="program-refs" select="$program-refs"/>
                    <xsl:with-param name="secondLevelItems" select="$secondLevelItems"/>
                </xsl:apply-templates>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="one-level">
        <xsl:param name="program-refs" select="/.." /> <!-- default value is empty node set -->
        
        <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
        <xsl:variable name="refs" select="$first/program-ref" />
        
        <xsl:if test="$refs[1]">
            <li class="{$firstLevel}">
                <xsl:value-of select="."/>
                <ul>
                     
                     <xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()]" /> 
                </ul>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item">
        <xsl:param name="program-refs" select="/.." /> <!-- default value is empty node set -->
        <xsl:param name="secondLevelItems" select="/.." /> <!-- default value is empty node set -->
        
        <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
        
        <xsl:if test="$first/second/@value = $secondLevelItems/@id">
            <li class="{$firstLevel}">
                <xsl:value-of select="."/>
                <ul>
                    <xsl:for-each select="$secondLevelItems">
                        <xsl:variable name="refs" select="$first/second[@value = current()/@id]/program-ref" />
                        <xsl:if test="$refs[1]">
                            <li class="{$secondLevel}">
                                <xsl:value-of select="."/>
                                <ul>
                                    <xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()]" /> 
                                </ul>
                            </li>
                        </xsl:if>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="program">
        <li class="program">
            <a href="{resolver:resolve('odf', @id)}">
                <xsl:value-of select="@title"/>
            </a>
            
            <xsl:if test="$displaySubProgram = 'true' and subprogram">
                <ul>
                    <xsl:for-each select="subprogram">
                        <li class="subprogram">
                            <a href="{resolver:resolve('odf', @id)}">
                                <xsl:value-of select="@title"/>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
</xsl:stylesheet>
