<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
   
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:url-encode="java.net.URLEncoder"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="str url-encode">
    
    <xsl:import href="service:web://pages/services/search/search-default/results/hit-common.xsl"/>
    
    <xsl:variable name="displaySubProgram" select="/search/additionalParameters/displaySubprogram"/>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="class-attribute">
        <xsl:text/>hit page<xsl:text> </xsl:text>
        <xsl:call-template name="common-utils-class"/>
    </xsl:template>
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit" mode="others">
        <xsl:call-template name="hit-subprograms"/>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="title-link">
        <a>
            <xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
            <xsl:value-of select="title"/>
        </a>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="abstract">
        <xsl:call-template name="hit-excerpt"/>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="date">
        <xsl:call-template name="hit-lastvalidation"/>
    </xsl:template>
    
    <xsl:template name="hit-subprograms">
        <xsl:param name="class">custom</xsl:param>
        
        <xsl:if test="$displaySubProgram != 'none' and subprogram">
            <xsl:if test="subprogram[not(@highlight) or @highlight = 'true']">
                <ul class="{$class} subprogram">
                    <xsl:for-each select="subprogram[not(@highlight) or @highlight = 'true']">
                        <li>
                           <xsl:if test="@highlight = 'true'"><xsl:attribute name="class">highlight</xsl:attribute></xsl:if>
                           <xsl:call-template name="hit-subprogram" />
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:if>
            
            <xsl:call-template name="hit-subprograms-others">
                <xsl:with-param name="class" select="$class"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-subprograms-others">
        <xsl:param name="class">custom</xsl:param>
        
        <xsl:if test="$displaySubProgram = 'all_with_highlight' and subprogram[@highlight = 'false']">
            <div class="other-subprograms">
                <a class="collapsed" href="#" onclick="$j(this).toggleClass('collapsed')">
                    <span>
                        <xsl:choose>
                            <xsl:when test="subprogram[@highlight = 'true']">
                                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NOT_MATCHING_SUBPROGRAM_OTHERS" i18n:catalogue="plugin.odf-web"/>   
                            </xsl:when>
                            <xsl:otherwise>
                                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NOT_MATCHING_SUBPROGRAM_SEE" i18n:catalogue="plugin.odf-web"/>   
                            </xsl:otherwise>
                        </xsl:choose>
                    </span>
                </a>
                <ul id="other-subprograms-{$uniqueId}-{position()}" class="{$class} subprogram others">
                    <xsl:for-each select="subprogram[@highlight = 'false']">
                        <li>
                           <xsl:call-template name="hit-subprogram" />
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-subprogram">
         <a>
            <xsl:attribute name="href">
                <xsl:call-template name="hit-href">
                    <xsl:with-param name="url" select="concat(../uri, '/', @path)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:value-of select="@title"/>
         </a>
    </xsl:template>
    
    <xsl:template name="hit-href">
        <xsl:param name="url" select="uri"/>
        
        <xsl:value-of select="ametys:siteUriPrefix()"/><xsl:text>/</xsl:text><xsl:value-of select="$url"/><xsl:text>.html</xsl:text>
        
        <xsl:variable name="wording-criteria">
            <xsl:for-each select="/search/form/values/criterion[text() != '']">
                <xsl:if test="/search/form/fields/criterion[@name = current()/@name and contains(@definition, 'common$wording$')]">
	                <xsl:for-each select="str:split(text())">
	                    <xsl:if test="position() &gt; 1">,</xsl:if>
		                <xsl:value-of select="url-encode:encode(.)"/>
	                </xsl:for-each>
	                <xsl:if test="position() != last()">,</xsl:if>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:if test="$wording-criteria != ''">
            <xsl:choose>
                <xsl:when test="contains(uri, '?')">&amp;</xsl:when>
                <xsl:otherwise>?</xsl:otherwise>
            </xsl:choose>
            <xsl:text>search-keywords=</xsl:text><xsl:value-of select="$wording-criteria"/>
        </xsl:if>
     </xsl:template>
    
</xsl:stylesheet>
