<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:dyn="http://exslt.org/dynamic"
                extension-element-prefixes="ametys xalan dyn">
	
    <xsl:import href="service:odf-web://pages/services/search/search_1.2.xsl"/>
    
    <xsl:variable name="search-css-class"><xsl:call-template name="search-css-class"/></xsl:variable>
    
    <!-- Variables -->
    <xsl:variable name="common-service-css-class-name">odf search search-criteria search-odf <xsl:value-of select="$search-css-class"/> search-map</xsl:variable>
    <xsl:variable name="map-height" select="'450'"/> <!-- hardcoded map height -->
    
    <xsl:variable name="iconBase"><xsl:value-of select="ametys:absoluteUriPrefix()"/>/plugins/web/icons/map/<xsl:value-of select="$skin"/>/</xsl:variable>
    <xsl:variable name="mapType">google.maps.MapTypeId.ROADMAP</xsl:variable>
    
    <!-- can be overriden to provide a meaningful color palette. -->
    <xsl:variable name="colorsRTF">
        <color>333333|FFFFFF</color>
    </xsl:variable>
    <xsl:variable name="colors" select="xalan:nodeset($colorsRTF)"/>
    
    <!-- default coordinates that can be overriden. -->
    <xsl:variable name="default-coord-lat" select="'0'" />
    <xsl:variable name="default-coord-lng" select="'0'" />
    <xsl:variable name="default-zoom" select="'1'" />
    
    <xsl:variable name="geocodeMetadataPath">content/geolocation</xsl:variable>
    
    <xsl:template name="search-css-class">search-odf-programs</xsl:template>
    
	<!-- +
		 | Template for results
		 + -->
	<xsl:template name="hits">
        <xsl:call-template name="display-geo-map" />
    
		<div class="results">
            <ul>
    			<xsl:for-each select="/search/hits/hit">
                    <xsl:call-template name="hit-page"/>
    			</xsl:for-each>
    		</ul>
        </div>
	</xsl:template>
    
    <xsl:template name="display-geo-map">
    
        <xsl:call-template name="display-geo-map-scripts" />
        
        <xsl:call-template name="display-geo-map-coordinates" />
        
        <!-- Allow the possibility to define the js function onAfterGmapViewerSetup via a template -->
        <xsl:call-template name="display-geo-map-js-listener" />
        
        <xsl:call-template name="display-geo-map-setup-viewer" />
        
        <xsl:call-template name="display-geo-map-placeholder" />
    </xsl:template>
    
    <xsl:template name="display-geo-map-scripts">
        <xsl:variable name="scheme" select="substring-before($absolute-uri-prefix, '://')"/>
        <script src="{$scheme}://maps.google.com/maps/api/js?key={ametys:siteParameter('google-api-key')}" type="text/javascript"></script>
        <script src="{ametys:pluginResourceURL('web', 'js/jquery.gmap.js')}" type="text/javascript"></script>
        <script src="{ametys:pluginResourceURL('web', 'js/GmapViewer.js')}" type="text/javascript"></script>
    </xsl:template>
    
    <xsl:template name="display-geo-map-coordinates">
        <script type="text/javascript">
            <xsl:comment>
                var geocode_map_<xsl:value-of select="$uniqueId"/> = [];
                var coordinates_<xsl:value-of select="$uniqueId"/> = {};
                var geocode_sorted_latlng_<xsl:value-of select="$uniqueId"/> = [];
                var coord_refs;
                
                var colors = []; <xsl:for-each select="$colors/color">colors.push('<xsl:value-of select="." />');</xsl:for-each>
                var cl = colors.length;
                
                var pinIdx = 0, lat, lng, vll, geocode_entry, coord_entry, geocode_sorted_hit;
                
                <xsl:variable name="hits" select="/search/hits/hit" />
                <xsl:for-each select="$hits">
                    <xsl:variable name="geocode-metadata" select="dyn:evaluate($geocodeMetadataPath)" />
                    
                    <xsl:if test="$geocode-metadata[@latitude != '' and @longitude != '']">
                        <xsl:variable name="tooltip-title"><xsl:call-template name="get-tooltip-title" /></xsl:variable>
                        // Keep reference to coordinates in the same order
                        geocode_sorted_hit = [];
                        geocode_sorted_latlng_<xsl:value-of select="$uniqueId"/>.push(geocode_sorted_hit);
                        coord_refs = []; // this array is used to handle duplicates for a single hit.
                        
                        <xsl:for-each select="$geocode-metadata[@latitude != '' and @longitude != '']">
                            lat = String(<xsl:value-of select="@latitude" />);
                            lng = String(<xsl:value-of select="@longitude" />);
                            vll = lat + lng;
                            
                            if ($j.inArray(vll, coord_refs) == -1)
                            {
                                coord_refs.push(vll); // add raw latlng value to coord refs for this hit.
                                
                                coord_entry = coordinates_<xsl:value-of select="$uniqueId"/>[lat] || {};
                                coord_entry = coord_entry[lng];
                                
                                if (!coord_entry) // no entry at the coordinates
                                {
                                    if (!coordinates_<xsl:value-of select="$uniqueId"/>[lat])
                                    {
                                        coordinates_<xsl:value-of select="$uniqueId"/>[lat] = {};
                                    }
                                    
                                    coord_entry = coordinates_<xsl:value-of select="$uniqueId"/>[lat];
                                    <xsl:call-template name="display-geo-map-add-coord-entry" />
                                    coord_entry[lng].titles = ['<xsl:value-of select="ametys:escapeJS($tooltip-title)"/>'];
                                    
                                    pinIdx++;
                                }
                                else
                                {
                                    coord_entry.titles.push('<xsl:value-of select="ametys:escapeJS($tooltip-title)"/>');
                                }
                                
                                // Keep reference to coordinates in the same order
                                // Note that direct XSL values are used (not JS string)
                                geocode_sorted_hit.push([<xsl:value-of select="@latitude" />, <xsl:value-of select="@longitude" />]);
                            }
                        </xsl:for-each>
                    </xsl:if>
                </xsl:for-each>
                
                // Prepare gmap data
                var gsl = geocode_sorted_latlng_<xsl:value-of select="$uniqueId"/>.length,
                    ghl, coord;
                for (var hitIdx = 0; hitIdx &lt; gsl; hitIdx++)
                {
                    geocode_sorted_hit = geocode_sorted_latlng_<xsl:value-of select="$uniqueId"/>[hitIdx];
                    ghl = geocode_sorted_hit.length;
                    
                    for (var coordIdx = 0; coordIdx &lt; ghl; coordIdx++)
                    {
                        coord = geocode_sorted_hit[coordIdx];
                        coord_entry = coordinates_<xsl:value-of select="$uniqueId"/>[String(coord[0])][String(coord[1])];
                        
                        if (!coord_entry.added)
                        {
                            coord_entry.added = true;
                            <xsl:call-template name="display-geo-map-add-map-entry" />
                            geocode_map_<xsl:value-of select="$uniqueId"/>.push(geocode_entry);
                        }
                    }
                }
            </xsl:comment>
        </script>
    </xsl:template>
    
    <xsl:template name="display-geo-map-add-coord-entry">
        <xsl:call-template name="display-geo-map-add-coord-entry-number" />
    </xsl:template>
    
    <xsl:template name="display-geo-map-add-coord-entry-number">
        coord_entry[lng] = {
            number: String(pinIdx + 1),
            color: colors[pinIdx % cl],
        };
    </xsl:template>
    
    <xsl:template name="display-geo-map-add-coord-entry-letter">
        coord_entry[lng] = {
            letter: String.fromCharCode(97 + (pinIdx % 25)),
            color: colors[pinIdx % cl],
        };
    </xsl:template>
    
    <xsl:template name="display-geo-map-add-map-entry">
        geocode_entry = {
            lat: coord[0],
            lng: coord[1],
            number: coord_entry.number || undefined,
            letter: coord_entry.letter || undefined,
            title: coord_entry.titles.join('&lt;br/&gt;')
        };
    </xsl:template>
    
    <xsl:template name="display-geo-map-setup-viewer">
        <script type="text/javascript">
            $j(document).ready(function () 
            {
                $j('#<xsl:value-of select="$uniqueId"/>-map').show();
                
                var data = {
                    iconBase: '<xsl:value-of select="$iconBase"/>',
                    zoomLevel: geocode_map_<xsl:value-of select="$uniqueId"/>.length &gt; 0 ? 15 : <xsl:value-of select="$default-zoom"/>,
                    lat: (geocode_map_<xsl:value-of select="$uniqueId"/>[0] || {}).lat || <xsl:value-of select="$default-coord-lat"/>,
                    lng: (geocode_map_<xsl:value-of select="$uniqueId"/>[0] || {}).lng || <xsl:value-of select="$default-coord-lng"/>,
                    mapTypeId: <xsl:value-of select="$mapType"/>,
                    markers: geocode_map_<xsl:value-of select="$uniqueId"/>,
                    polygons: []
                };
                
                var gmapViewer = new GmapViewer();
                gmapViewer.setUp('#<xsl:value-of select="$uniqueId"/>-map', data, true);
                
                // onAfterGmapViewerSetup hook.
                if ($j.isFunction(window.onAfterGmapViewerSetup_<xsl:value-of select="$uniqueId"/>))
                {
                    window.onAfterGmapViewerSetup_<xsl:value-of select="$uniqueId"/>(gmapViewer, geocode_sorted_latlng_<xsl:value-of select="$uniqueId"/>, coordinates_<xsl:value-of select="$uniqueId"/>);
                }
            });
        </script>
    </xsl:template>
    
    <xsl:template name="display-geo-map-placeholder">
        <!-- map placeholder -->
        <div id="{$uniqueId}-map" class="map" style="height: {$map-height}px; display: none;">
        </div>
    </xsl:template>
    
    <!-- empty by default. Can be overriden in skin to define the 'onAfterGmapViewerSetup' js function -->
    <xsl:template name="display-geo-map-js-listener" />
    
    <!-- Tooltip title with embedded page link. -->
    <xsl:template name="get-tooltip-title">
        <xsl:variable name="href"><xsl:call-template name="hit-href"/></xsl:variable>
        
        <!-- <a title="page-title" href="page-href">page-title</a> -->
        <xsl:value-of select="concat('&lt;a title=&quot;', title, '&quot; href=&quot;', $href , '&quot; &gt;', title, '&lt;/a&gt;')" />
    </xsl:template>
    
    <!-- Template used to display a page -->
    <xsl:template name="hit-page">
        <li>
            <xsl:attribute name="class">hit page<xsl:text> </xsl:text>
                <xsl:call-template name="common-utils-class"/>
            </xsl:attribute>
            
            <a title="{title}">
               	<xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
            	<xsl:value-of select="title"/>
            </a>
            <xsl:call-template name="hit-scoring"/>
            <xsl:call-template name="excerpt"/>  
            <xsl:call-template name="hit-lastvalidation"/>  
            <xsl:call-template name="hit-subprograms"/>
            <xsl:call-template name="hit-geocode-info"/> <!-- adding geocode data to the default template -->
        </li>
    </xsl:template>
    
    <xsl:template name="hit-geocode-info">
        
        <xsl:variable name="geocode-metadata" select="dyn:evaluate($geocodeMetadataPath)" />
        <xsl:if test="$geocode-metadata[@latitude != '' and @longitude != '']">
            
            <!-- variable used to avoid duplicates geocode -->
            <xsl:variable name="entriesRTF">
                <xsl:for-each select="$geocode-metadata[@latitude != '' and @longitude != '']">
                    <geocode latitude="{@latitude}" longitude="{@longitude}" />
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="entries" select="xalan:nodeset($entriesRTF)"/>
            
            <div class="geoloc-info">
                <xsl:for-each select="$entries/geocode">
                    <xsl:if test="not(preceding-sibling::*[@latitude = current()/@latitude and @longitude = current()/@longitude])">
                        <div class="geoloc-entry">
                            <!-- accessibility -->
                            <noscript>
                                <a href="https://maps.google.com/maps?q={@latitude},{@longitude}&amp;ll={@latitude},{@longitude}">
                                    <i18n:text i18n:key="PLUGINS_WEB_SERVICE_FILTERED_CONTENTS_GEOCODE_LINK_SEE_MAP_LABEL" i18n:catalogue="plugin.web"/><xsl:text> (</xsl:text>
                                    <xsl:value-of select="round(@latitude*10000) div 10000" /><xsl:text>°</xsl:text><i18n:text i18n:key="PLUGINS_CMS_GEOCODE_DIRECTIONS_NORTH" i18n:catalogue="plugin.cms"/><xsl:text>, </xsl:text>
                                    <xsl:value-of select="round(@longitude*10000) div 10000" /><xsl:text>°</xsl:text><i18n:text i18n:key="PLUGINS_CMS_GEOCODE_DIRECTIONS_EST" i18n:catalogue="plugin.cms"/><xsl:text>)</xsl:text>
                                </a>
                            </noscript>
                        </div>
                    </xsl:if>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
