/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


(function() {
    var AOMF;
    
    if (!window.Ametys)
    {
        AOMF = window.Ametys = {};
    }
    if (!AOMF.odf)
    {
        AOMF = AOMF.odf = {};
    }
    
    if (AOMF.MultiFacets)
    {
        // file already loaded
        return;
    }
    else
    {
        AOMF = AOMF.MultiFacets = {};
    }
    
    var _formsData = {};
    
    AOMF.getFormData = function()
    {
        return _formsData;
    };
    
    // Add a 'onchange' listener on each checkbox when DOM is ready
    // Used to update the facets when an item is selected or deselected;
    // Same for the title and textfield input fields
    AOMF.onReady = function()
    {
        $j.each(_formsData, function(formId, formData) {
            var $form = $j('#' + formId);
            
            AOMF.initiliazeGroups($form);
            AOMF.handleFacetsVisibility($form);
            
            $form.find('.field .input .checkbox input').change(AOMF.onFieldChange);
            $form.find('#search-title-' + formData.uniqueId).change(AOMF.onFieldChange);
            $form.find('#search-textfield-' + formData.uniqueId).change(AOMF.onFieldChange);
            $form.find('#search-all-words-' + formData.uniqueId).change(AOMF.onFieldChange);
            $form.find('#search-exact-wording-' + formData.uniqueId).change(AOMF.onFieldChange);
            $form.find('#search-no-words-' + formData.uniqueId).change(AOMF.onFieldChange);
        });
    }
    $j(function() {
        AOMF.onReady();
    });
    
    AOMF.onFieldChange = function(evt) {
        
        var $this = $j(this),
        $form = $this.closest('form'),
        formId = $form.attr('id');
        
        if ($this.is(':checkbox'))
        {
            var oldValue = $this.data('oldValue'),
                newValue = $this.is(':checked');
            
            // update old value
            $this.data('oldValue', newValue);
            
            if (oldValue != null && oldValue == newValue)
            {
                // not a real change because the value has not changed, ignore it.
                return; 
            }
        }
        
        AOMF.updateFacets(formId);
    };
    
    AOMF.updateFacets = function(formId) {
        
        var formData = _formsData[formId],
            $form = $j('#' + formId),
            params = AOMF.getFormValues($form);
        
        // merge the form data params into the params object
        $j.extend(params, formData.params);
        
        // server request
        $j.ajax({
            type: "POST",
            url: formData.url,
            data: params,
            traditional: true, // _do not remove_ otherwise parameter name with multiple values will not be handled as expected on the server
            success: function(data) {
                AOMF.updateFacetsCb(data, $form); // binding the form as an argument to the callback (with a closure).
                AOMF.handleFacetsVisibility($form)
            },
            dataType: 'xml'
        });
    };
    
    AOMF.getFormValues = function($form)
    {
        var valuesArray = $form.serializeArray(), 
            values = {};
        
        $j.each(valuesArray, function() {
            if (this.value !== undefined)
            {
                if (values[this.name] !== undefined)
                {
                    values[this.name].push(this.value);
                }
                else
                {
                    values[this.name] = [this.value];
                }
            }
        });
        
        return values;
    };
    
    AOMF.updateFacetsCb = function(data, $form)
    {
        var uniqueId = _formsData[$form.attr('id')].uniqueId;
        
        // Iterates on list criteria
        $j('> search > form > facets > facet', data).each(function() {
            var $this = $j(this),
                criterionName = $this.attr('name');
            
            $this.find('item').each(function() {
                var $this = $j(this),
                    value = $this.attr('value'),
                    count = '(' + $this.attr('count') + ')',
                    $countEl = $form.find('div.field div.input div.checkbox label[for="search-' + criterionName.replace(/\//g, '-') + '-' + uniqueId + '-' + value.replace(/\//g, '-') + '"] span.facet-count');
                    
                if (count != $countEl.text())
                {
                    $countEl.text(count).hide(0).fadeIn('slow');
                }
            });
        });
    };
    
    AOMF.setupForm = function(uniqueId, formId, url, siteName, lang, zoneItemId, maxEntryCount, hideZero)
    {
        var maxEntryCount = maxEntryCount || 0,
            hideZero = hideZero === true; // false by default 
        
        _formsData[formId] = {
            url: url,
            uniqueId: uniqueId,
            maxEntryCount: maxEntryCount,
            showHideFeatureEnabled: maxEntryCount < 0,
            hideZero: hideZero,
            groupsDisplayAllState: {},
            params: {
                siteName: siteName,
                lang: lang,
                zoneItemId: zoneItemId
            }
        };
    };
    
    // Hide facets if entry index is superior to maxEntryCount and if the entry is not selected
    // Display a show all entry link
    AOMF.handleFacetsVisibility  = function($form)
    {
        var formId = $form.attr('id'),
            formData = _formsData[formId],
            showHideFeatureEnabled = formData.showHideFeatureEnabled,
            maxEntryCount = formData.maxEntryCount,
            hideZero = formData.hideZero,
            $checkboxGroups = $form.find('.field .input:has(.checkbox)');
        
        $j.each($checkboxGroups, function() {
            
            var $group = $j(this),
                inDisplayAllState = AOMF.isDisplayAllState($group, formData),
                $checkboxes = $group.find('.checkbox'),
                nonNullentriesAfterMaxCount = false,
                atLeastOneVisible = false;
            
            if (showHideFeatureEnabled && $checkboxes.length < maxEntryCount)
            {
                $checkboxes = $checkboxes.sort(AOMF.sortByCountDesc);
            }
            
            $checkboxes.each(function(index) {
                var $checkbox = $j(this),
                    hide = false,
                    show = false;
                
                if (!$checkbox.find('input:checked').prop('checked'))
                {
                    if (hideZero && AOMF.getCheckboxCount($checkbox) <= 0)
                    {
                        hide = true;
                    }
                    else if (showHideFeatureEnabled)
                    {
                        if (inDisplayAllState)
                        {
                            show = true;
                            atLeastOneVisible = true;
                            if (index <= maxEntryCount)
                            {
                                nonNullentriesAfterMaxCount = true;
                            }
                        }
                        else
                        {
                            if (index < maxEntryCount)
                            {
                                show = true;
                                atLeastOneVisible = true;
                            }
                            else
                            {
                                hide = true;
                                nonNullentriesAfterMaxCount = true;
                            }
                        }
                    }
                    else
                    {
                        show = true;
                        atLeastOneVisible = true;
                    }
                    
                    if (hide)
                    {
                        $checkbox.hide();
                    }
                    else if (show && $checkbox.is(':hidden'))
                    {
                        $checkbox.fadeIn('slow');
                    }
                }
                else
                {
                    atLeastOneVisible = true;
                }
            });
            
            // Handle the visibility of the div that must be shown when there is no entry available.
            var $noEntryDiv = $group.find('div.no-entry-msg');
            $noEntryDiv[atLeastOneVisible ? 'hide' : 'show']();
            
            // Handling link more/less visibility
            if (showHideFeatureEnabled)
            {
                var $linkMore = $group.find('a.see-more'),
                    $linkLess = $group.find('a.see-less');
                
                if (nonNullentriesAfterMaxCount)
                {
                    // link more or link less must be visible depending on the display state
                    if (inDisplayAllState)
                    {
                        $linkMore.hide();
                        $linkLess.show();
                    }
                    else
                    {
                        $linkLess.hide();
                        $linkMore.show();
                    }
                }
                else
                {
                    // nothing to hide/show, hide both links
                    $linkMore.hide();
                    $linkLess.hide();
                }
            }
        });
    };
    
    // Indicate the visibility state of the group (ie. a criterion) of checkboxes.
    // If false, it means that some entries are hidden because there are more entries than maxEntryCount.
    AOMF.isDisplayAllState = function($group, formData)
    {
        var groupId = $group.attr('id'),
            isDisplayAllState;
        
        // Show/hide feature disabled -> always display all
        if (!formData.showHideFeatureEnabled)
        {
            isDisplayAllState = true;
        }
        
        // See more link visible implies that some entries are hidden.
        var $linkMore = $group.find('a.see-more');
        if ($linkMore.is(':visible'))
        {
            isDisplayAllState = false;
        }
        
        // See less link visible implies that all entries are displayed.
        var $linkLess = $group.find('a.see-less');
        if ($linkLess.is(':visible'))
        {
            isDisplayAllState = true;
        }
        
        if (isDisplayAllState == undefined)
        // both links are hidden implies try to find the previous display all state
        {
            isDisplayAllState = formData.groupsDisplayAllState[groupId];
        }
        
        if (isDisplayAllState == undefined)
        {
            // default
            isDisplayAllState = false;
        }
        
        // memorize the state
        formData.groupsDisplayAllState[groupId] = isDisplayAllState;
        
        return isDisplayAllState;
    };
    
    AOMF.initiliazeGroups = function($form)
    {
        var formId = $form.attr('id'),
            formData = _formsData[formId],
            showHideFeatureEnabled = formData.showHideFeatureEnabled,
            maxEntryCount = formData.maxEntryCount,
            hideZero = formData.hideZero,
            $checkboxGroups = $form.find('.field .input:has(.checkbox)');
            
        $j.each($checkboxGroups, function() {
            
            var $group = $j(this);
            
            // info div if group is empty
            var $noEntryDiv = $j("<div class=\"no-entry-msg\">{{i18n plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_MULTI_NO_ENTRY_LINK}}</div>"); // hidden by default
            
            $noEntryDiv.hide();
            $group.append($noEntryDiv);
                
            if (showHideFeatureEnabled)
            {
                var $checkboxes = $group.find('.checkbox');
                
                var $linkWrapper = $j('<div class="see-more-less-wrapper"/>'),
                    $linkMore = $j("<a class=\"see-more\" href=\"#\" {{i18n plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_MULTI_SHOW_MORE_LINK}}</a>"),
                    $linkLess = $j("<a class=\"see-less\" href=\"#\" {{i18n plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_MULTI_SHOW_LESS_LINK}}</a>").hide(); // link less hidden by default.
                
                $linkMore.click(function() {
                    $checkboxes.each(function() {
                        var $checkbox = $j(this);
                        
                        if ($checkbox.is(':hidden') && (!hideZero || AOMF.getCheckboxCount($checkbox) < 0))
                        {
                            $checkbox.fadeIn('slow');
                        }
                    });
                    
                    $linkMore.hide();
                    $linkLess.show();
                });
                
                $linkLess.click(function() {
                    if ($checkboxes.length < maxEntryCount)
                    {
                        $checkboxes = $checkboxes.sort(AOMF.sortByCountDesc);
                    }
                    
                    $checkboxes.each(function(index) {
                        var $checkbox = $j(this);
                        
                        if (index <= maxEntryCount && !$checkbox.find('input:checked').prop('checked') && $checkbox.is(':visible'))
                        {
                            $checkbox.fadeOut('slow');
                        }
                    });
                    
                    $linkLess.hide();
                    $linkMore.show();
                });
                
                $linkWrapper.append($linkMore);
                $linkWrapper.append($linkLess);
                $group.append($linkWrapper);
            }
        });
    };
    
    AOMF.sortByCountDesc = function(a, b)
    {
        return AOMF.getCheckboxCount($j(b)) - AOMF.getCheckboxCount($j(a));
    };
    
    AOMF.getCheckboxCount = function($checbkox)
    {
        var rawCount = $checbkox.find('label span.facet-count').text(); // include the parenthesis -> ( + number + )
        return rawCount.substring(1, rawCount.length - 1);
    };
})();

