/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.cart;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;

/**
 * This observer deletes the references of a {@link AbstractProgram} or a {@link Course} on content deletion for all users' preferences.
 */
public class ODFCartUserPreferencesObserver implements Observer, Serviceable
{
    private ODFCartUserPreferencesStorage _odfUserPrefStorage;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _odfUserPrefStorage = (ODFCartUserPreferencesStorage) smanager.lookup(ODFCartUserPreferencesStorage.ROLE);
    }
    
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_CONTENT_DELETING);
    }

    @Override
    public int getPriority()
    {
        return MAX_PRIORITY;
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Map<String, Object> arguments = event.getArguments();
        if (arguments.containsKey(ObservationConstants.ARGS_CONTENT))
        {
            Content content = (Content) arguments.get(ObservationConstants.ARGS_CONTENT);
            if (content instanceof AbstractProgram || content instanceof Course)
            {
                _odfUserPrefStorage.removeContentFromUserPreferences(content.getId());
            }
        }
    }
}
