/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.URIUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.runtime.config.Config;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class OdfURIResolver
extends org.ametys.odf.OdfURIResolver
implements Contextualizable {
    private Context _context;
    private SiteManager _siteManager;
    private OdfPageResolver _odfPageResolver;
    private RenderingContextHandler _renderingContextHandler;
    private URIPrefixHandler _prefixHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._odfPageResolver = (OdfPageResolver)((Object)manager.lookup(OdfPageResolver.ROLE));
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
        this._prefixHandler = (URIPrefixHandler)manager.lookup(URIPrefixHandler.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public String resolve(String uri, boolean download, boolean absolute, boolean internal) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentSite = (String)request.getAttribute("finalsite");
        if (currentSite == null) {
            currentSite = (String)request.getAttribute("site");
        }
        if (currentSite == null) {
            currentSite = (String)request.getAttribute("siteName");
        }
        int i = uri.indexOf(59);
        String contentId = uri;
        if (i != -1) {
            contentId = uri.substring(0, i);
        }
        Content content = (Content)this._resolver.resolveById(contentId);
        Page odfRootPage = this._odfPageResolver.getOdfRootPage(currentSite, content.getLanguage(), ((ProgramItem)content).getCatalog());
        RenderingContext context = this._renderingContextHandler.getRenderingContext();
        ProgramPage page = null;
        if (content instanceof Program) {
            page = this._odfPageResolver.getProgramPage((Program)content, odfRootPage.getSiteName());
        } else if (content instanceof SubProgram) {
            page = this._getSubProgramPage((SubProgram)content, odfRootPage, uri.split(";"));
        } else if (content instanceof Course) {
            page = this._getCoursePage((Course)content, odfRootPage, uri.split(";"));
        }
        if (page == null) {
            String siteName = (String)Config.getInstance().getValue("odf.web.site.name");
            return this._getContentURI(content, siteName, context, absolute, internal);
        }
        String siteName = page.getSiteName();
        String pagePath = page.getSitemapName() + "/" + page.getPathInSitemap() + ".html";
        try {
            if (!siteName.equals(currentSite) && context == RenderingContext.FRONT) {
                String url = this._siteManager.getSite(siteName).getUrl();
                return url + "/" + pagePath;
            }
            if (context != RenderingContext.BACK) {
                StringBuilder result = new StringBuilder();
                if (internal) {
                    result.append("cocoon://").append(siteName);
                } else if (absolute) {
                    result.append(this._prefixHandler.getAbsoluteUriPrefix(siteName));
                } else {
                    result.append(this._prefixHandler.getUriPrefix(siteName));
                }
                result.append("/").append(pagePath);
                return URIUtils.encodePath((String)result.toString());
            }
            return "javascript:(function(){parent.Ametys.tool.ToolsManager.openTool('uitool-page', {id:'" + page.getId() + "'});})()";
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Page _getSubProgramPage(SubProgram subProgram, Page odfRootPage, String[] paths) {
        if (odfRootPage == null) {
            return null;
        }
        if (paths.length > 2) {
            return this._odfPageResolver.getSubProgramPage(odfRootPage, subProgram, (List<String>)Arrays.asList(paths).reversed(), true);
        }
        return this._odfPageResolver.getSubProgramPage(odfRootPage, subProgram, null);
    }

    private Page _getCoursePage(Course course, Page odfRootPage, String[] paths) {
        if (odfRootPage == null) {
            return null;
        }
        if (paths.length >= 2) {
            return this._odfPageResolver.getCoursePage(odfRootPage, course, (List<String>)Arrays.asList(paths).subList(1, paths.length).reversed(), true);
        }
        return this._odfPageResolver.getCoursePage(odfRootPage, course, (AbstractProgram)null);
    }

    protected String _getContentURI(Content content, String siteName, RenderingContext context, boolean absolute, boolean internal) {
        try {
            if (context == RenderingContext.FRONT) {
                return "";
            }
            if (context != RenderingContext.BACK) {
                StringBuilder result = new StringBuilder();
                if (internal) {
                    result.append("cocoon://").append(siteName);
                } else if (absolute) {
                    result.append(this._prefixHandler.getAbsoluteUriPrefix());
                } else {
                    result.append(this._prefixHandler.getUriPrefix());
                }
                result.append("/").append("_wrapped-content.html");
                String query = "contentId=" + content.getId() + "&userLocale=" + content.getLanguage() + "&siteName=" + siteName;
                return new URI(null, null, result.toString(), query, null).toASCIIString();
            }
            return "javascript:(function(){parent.Ametys.tool.ToolsManager.openTool('uitool-content', {id:'" + content.getId() + "'});})()";
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

