/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.source;

import java.util.ArrayList;
import java.util.List;

import org.ametys.odf.source.DefaultODFView;

/**
 * This implementation of a {@link ODFWebView} looks first in the directory skin://stylesheets/catalog/ then defaults to {@link DefaultODFView}.
 */
public class ODFWebView extends DefaultODFView
{
    @Override
    protected List<String> getLocations(String pluginName, String filePath)
    {
        List<String> locations = new ArrayList<>();
        
        // First look for the file in the skin.
        locations.add("skin://" + filePath);
        
        // If it was not found, look in the default locations.
        locations.addAll(super.getLocations(pluginName, filePath));
        
        return locations;
    }
    
    @Override
    protected List<String> _getDefaultSourceURIs(String pluginName, String filePath)
    {
        List<String> locations = new ArrayList<>();
        
        if (!"odf-web".equals(pluginName))
        {
            // For legacy, then look in the web plugin.
            locations.add("plugin:odf-web://" + filePath);
        }
        
        locations.addAll(super._getDefaultSourceURIs(pluginName, filePath));
        
        return locations;
    }
}
