/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.cdmfr;

import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.odf.cdmfr.CDMFRTagsConstants;
import org.ametys.odf.cdmfr.CDMfrExtension;
import org.ametys.odf.course.Course;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.person.Person;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramFactory;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.web.repository.site.SiteManager;

/**
 * Web CDMfr extension for Ametys
 */
public class WebAmetysCDMfrExtension implements CDMfrExtension, Serviceable
{
    private OdfPageResolver _odfPageResolver;
    private SiteManager _siteManager;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _odfPageResolver = (OdfPageResolver) manager.lookup(OdfPageResolver.ROLE);
        _siteManager = (SiteManager) manager.lookup(SiteManager.ROLE);
    }
    
    @Override
    public void abstractProgram2CDM(ContentHandler contentHandler, AbstractProgram<? extends ProgramFactory> program, Set<String> persons, Set<String> orgUnits) throws SAXException
    {
        // Empty
    }

    public void program2CDM(ContentHandler contentHandler, Program program, Set<String> persons, Set<String> orgUnits) throws SAXException
    {
        ProgramPage page = _odfPageResolver.getProgramPage(program);
        
        if (page != null)
        {
            String pagePath = page.getSitemap().getName() + "/" + page.getPathInSitemap() + ".html";
            String siteName = page.getSiteName();
            
            String url = _siteManager.getSite(siteName).getUrl();
            if (!StringUtils.endsWith("/", url))
            {
                url += "/";
            }
            url += pagePath;
            XMLUtils.createElement(contentHandler,  CDMFRTagsConstants.NAMESPACE_AMETYS_CDM + "webLink", url);
        }
    }
    
    public void subProgram2CDM(ContentHandler contentHandler, SubProgram subProgram, Set<String> persons, Set<String> orgUnits) throws SAXException
    {
        // Empty
    }

    public void course2CDM(ContentHandler contentHandler, Course course, Set<String> persons, Set<String> orgUnits) throws SAXException
    {
        // Empty
    }

    public void orgunit2CDM(ContentHandler contentHandler, OrgUnit orgunit) throws SAXException
    {
        // Empty
    }

    public void person2CDM(ContentHandler contentHandler, Person person) throws SAXException
    {
        // Empty
    }

    public void container2CDM(ContentHandler contentHandler, Container container, Set<String> persons, Set<String> orgUnits) throws SAXException
    {
        // Empty
    }
}
