/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.observation;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.commons.collections.PredicateUtils;
import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.observation.OdfObservationConstants;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.web.synchronization.AbstractSynchronizeObserver;


/**
 * {@link Observer} for observing content translation in order to synchronize live workspace.
 */
public class SynchronizedContentTranslatedObserver extends AbstractSynchronizeObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(OdfObservationConstants.ODF_CONTENT_TRANSLATED);
    }
    
    @Override
    protected void _internalObserve(Event event, Session liveSession) throws RepositoryException
    {
        Content content = (Content) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
        
        if (!(content instanceof JCRAmetysObject))
        {
            return;
        }
        
        Node node = ((JCRAmetysObject) content).getNode();
        
        String translationNodeName = RepositoryConstants.NAMESPACE_PREFIX + ":translations";
        
        try
        {
            Node clonedNode = liveSession.getNodeByIdentifier(node.getIdentifier());
            Node translationsNode = node.getNode(translationNodeName);
            
            Node liveTranslationsNode = null;
            if (clonedNode.hasNode(translationNodeName))
            {
                liveTranslationsNode = clonedNode.getNode(translationNodeName);
            }
            else
            {
                liveTranslationsNode = clonedNode.addNode(translationNodeName, "ametys:compositeMetadata");
            }
            
            _synchronizeComponent.cloneNodeAndPreserveUUID(translationsNode, liveTranslationsNode, PredicateUtils.truePredicate(), PredicateUtils.falsePredicate());
        }
        catch (ItemNotFoundException e)
        {
            // content does not exist in the live workspace
        }
        
        if (liveSession.hasPendingChanges())
        {
            liveSession.save();
        }
        
    }
}
