/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.program;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.search.SearchResults;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.ConstantNilScoreQuery;
import org.ametys.cms.search.query.ContentTypeQuery;
import org.ametys.cms.search.query.DocumentTypeQuery;
import org.ametys.cms.search.query.JoinQuery;
import org.ametys.cms.search.query.MatchAllQuery;
import org.ametys.cms.search.query.MaxScoreOrQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.cms.search.solr.SearcherFactory;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.web.frontoffice.SearchGenerator;
import org.ametys.web.repository.page.Page;
import org.ametys.web.search.query.PageContentQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FrontODFSearch
extends SearchGenerator {
    protected List<String> _matchingSubProgramIds;
    private DisplaySubprogramMode _displaySubprogramMode;
    private OdfPageResolver _odfPageResolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfPageResolver = (OdfPageResolver)((Object)smanager.lookup(OdfPageResolver.ROLE));
    }

    protected Set<String> getContentTypes(Request request) {
        return Set.of(this.parameters.getParameter("contentType", "org.ametys.plugins.odf.Content.program"));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this._displaySubprogramMode = null;
        this._matchingSubProgramIds = new ArrayList<String>();
        super.generate();
    }

    protected List<Query> getContentQueries(Request request, Collection<String> siteNames, String language) {
        List contentQueries = super.getContentQueries(request, siteNames, language);
        String catalog = this.parameters.getParameter("catalog", request.getParameter("catalog"));
        contentQueries.add(new ConstantNilScoreQuery((Query)new StringQuery("catalog", catalog)));
        String skillId = request.getParameter("skillId");
        if (ODFSkillsHelper.isSkillsEnabled() && StringUtils.isNotBlank((CharSequence)skillId)) {
            contentQueries.add(new OrQuery(new Query[]{new StringQuery("skills", skillId), new StringQuery("transversalSkills", skillId)}));
        }
        return contentQueries;
    }

    protected Query getQuery(Request request, Collection<String> siteNames, String language) throws IllegalArgumentException {
        ArrayList<Object> finalQueries = new ArrayList<Object>();
        List wordingQueries = this.getWordingQueries(request, siteNames, language);
        MatchAllQuery wordingQuery = wordingQueries.isEmpty() ? new MatchAllQuery() : new AndQuery((Collection)wordingQueries);
        ArrayList<MatchAllQuery> pagesQueries = new ArrayList<MatchAllQuery>();
        pagesQueries.addAll(this.getPageQueries(request, siteNames, language));
        if (!pagesQueries.isEmpty()) {
            pagesQueries.add(wordingQuery);
            finalQueries.add(new AndQuery(pagesQueries));
        }
        ArrayList<Query> contentQueries = new ArrayList<Query>(wordingQueries);
        contentQueries.addAll(this.getContentQueries(request, siteNames, language));
        AndQuery contentQuery = new AndQuery(contentQueries);
        ArrayList<AndQuery> contentOrResourcesQueries = new ArrayList<AndQuery>();
        contentOrResourcesQueries.add(contentQuery);
        contentOrResourcesQueries.addAll(this.getContentResourcesOrAttachmentQueries((Query)wordingQuery));
        OrQuery programContentQuery = new OrQuery(contentOrResourcesQueries);
        PageContentQuery programPageQuery = new PageContentQuery((Query)programContentQuery);
        finalQueries.add(programPageQuery);
        Query subProgramPageQuery = null;
        if (this._searchOnSubPrograms()) {
            subProgramPageQuery = this.getSubProgramPageQuery((Query)programContentQuery);
            finalQueries.add(subProgramPageQuery);
        }
        return finalQueries.isEmpty() ? new MatchAllQuery() : (finalQueries.size() == 1 ? (Query)finalQueries.get(0) : new MaxScoreOrQuery(finalQueries));
    }

    protected SearchResults<AmetysObject> search(Request request, Collection<String> siteNames, String language, int pageIndex, int start, int maxResults, boolean saxResults) throws Exception {
        DisplaySubprogramMode displaySubProgramMode;
        this._matchingSubProgramIds = new ArrayList<String>();
        if (saxResults && ((displaySubProgramMode = this.getDisplaySubProgramMode()).equals((Object)DisplaySubprogramMode.ALL_WITH_HIGHLIGHT) || displaySubProgramMode.equals((Object)DisplaySubprogramMode.MATCHING_SEARCH_ONLY))) {
            this._matchingSubProgramIds = this.getSubProgramsMatchingSearch(request, siteNames, language);
        }
        return super.search(request, siteNames, language, pageIndex, start, maxResults, saxResults);
    }

    protected List<String> getSubProgramsMatchingSearch(Request request, Collection<String> siteNames, String language) throws Exception {
        List wordingQueries = this.getWordingQueries(request, siteNames, language);
        MatchAllQuery wordingQuery = wordingQueries.isEmpty() ? new MatchAllQuery() : new AndQuery((Collection)wordingQueries);
        ArrayList<Object> contentQueries = new ArrayList<Object>(wordingQueries);
        contentQueries.addAll(this.getContentQueries(request, siteNames, language));
        contentQueries.add(new ContentTypeQuery(new String[]{"org.ametys.plugins.odf.Content.subProgram"}));
        AndQuery contentQuery = new AndQuery(contentQueries);
        ArrayList<AndQuery> contentOrResourcesQueries = new ArrayList<AndQuery>();
        contentOrResourcesQueries.add(contentQuery);
        contentOrResourcesQueries.addAll(this.getContentResourcesOrAttachmentQueries((Query)wordingQuery));
        SearcherFactory.Searcher searcher = this._searcherFactory.create().withQuery((Query)new OrQuery(contentOrResourcesQueries)).addFilterQuery((Query)new DocumentTypeQuery("content")).withLimits(0, Integer.MAX_VALUE).setCheckRights(this._checkRights());
        AmetysObjectIterable subPrograms = searcher.search();
        return subPrograms.stream().map(ao -> ao.getId()).collect(Collectors.toList());
    }

    protected Query getSubProgramPageQuery(Query contentQuery) {
        ConstantNilScoreQuery subProgramTypeQuery = new ConstantNilScoreQuery((Query)new ContentTypeQuery(new String[]{"org.ametys.plugins.odf.Content.subProgram"}));
        AndQuery subProgramContentQuery = new AndQuery(new Query[]{subProgramTypeQuery, contentQuery});
        return new SubProgramPageContentQuery(this, (Query)subProgramContentQuery);
    }

    protected void saxAdditionalInfosOnPageHit(Page page) throws SAXException {
        super.saxAdditionalInfosOnPageHit(page);
        DisplaySubprogramMode displaySubProgramMode = this.getDisplaySubProgramMode();
        if (displaySubProgramMode != DisplaySubprogramMode.NONE && page instanceof ProgramPage) {
            ContentType contentType = (ContentType)this._cTypeExtPt.getExtension("org.ametys.plugins.odf.Content.subProgram");
            View view = Optional.ofNullable(contentType).map(cType -> cType.getView("index")).orElse(null);
            if (page instanceof ProgramPage) {
                String programPath = page.getPathInSitemap();
                AbstractProgram program = ((ProgramPage)page).getProgram();
                for (ProgramPart childProgramPart : program.getProgramPartChildren()) {
                    if (!(childProgramPart instanceof SubProgram)) continue;
                    SubProgram subProgram = (SubProgram)childProgramPart;
                    boolean matchSearch = this._matchingSubProgramIds.contains(subProgram.getId());
                    if (this._displaySubprogramMode.equals((Object)DisplaySubprogramMode.MATCHING_SEARCH_ONLY) && !matchSearch) continue;
                    AttributesImpl attrs = new AttributesImpl();
                    ProgramPage subProgramPage = this._odfPageResolver.getSubProgramPage(subProgram, program, page.getSiteName());
                    if (subProgramPage != null) {
                        attrs.addCDATAAttribute("path", StringUtils.substringAfterLast((String)subProgramPage.getPathInSitemap(), (String)programPath));
                    } else {
                        this.getLogger().warn("The subprogram '" + subProgram.getId() + "' was returned from the search but its virtual page could not be resolved");
                    }
                    attrs.addCDATAAttribute("title", subProgram.getTitle());
                    if (this._displaySubprogramMode == DisplaySubprogramMode.ALL_WITH_HIGHLIGHT) {
                        attrs.addCDATAAttribute("highlight", String.valueOf(matchSearch));
                    }
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"subprogram", (Attributes)attrs);
                    try {
                        subProgram.dataToSAX(this.contentHandler, (ViewItemAccessor)view);
                    }
                    catch (Exception e) {
                        this.getLogger().error("An error occurred during saxing subprogram '" + subProgram.getId() + "' metadata", (Throwable)e);
                    }
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"subprogram");
                }
            }
        }
    }

    protected DisplaySubprogramMode getDisplaySubProgramMode() {
        if (this._displaySubprogramMode == null) {
            String displaySubprogramsParam = this.parameters.getParameter("display-subprograms", "none");
            this._displaySubprogramMode = DisplaySubprogramMode.valueOf(displaySubprogramsParam.toUpperCase());
        }
        return this._displaySubprogramMode;
    }

    protected boolean _searchOnSubPrograms() {
        return this.parameters.getParameterAsBoolean("subprogram-search", false);
    }

    protected void addContentTypeQuery(Collection<Query> queries, Request request) {
        ArrayList<String> cTypes = new ArrayList<String>(this.getContentTypes(request));
        queries.add((Query)new PageContentQuery((Query)new ContentTypeQuery(cTypes)));
    }

    public static enum DisplaySubprogramMode {
        NONE,
        ALL,
        ALL_WITH_HIGHLIGHT,
        MATCHING_SEARCH_ONLY;

    }

    class SubProgramPageContentQuery
    extends JoinQuery {
        public SubProgramPageContentQuery(FrontODFSearch this$0, Query subQuery) {
            super(subQuery, new String[]{"contentIds_s_dv", "childProgramParts"});
        }
    }
}

