/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.workflow;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workflow.support.WorkflowProvider.AmetysObjectWorkflow;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.Step;

/**
 * OS workflow function to send mail after an action is triggered for ODF contents
 */
public class SendMailToUserFunction extends SendMailFunction
{
    @Override
    protected Set<UserIdentity> _getUsers(WorkflowAwareContent content, Set<String> rights) throws WorkflowException
    {
        Set<UserIdentity> users = new HashSet<>();
        
        AmetysObjectWorkflow workflow = _workflowProvider.getAmetysObjectWorkflow(content);
        long workflowId = content.getWorkflowId();
        
        Iterator<Step> steps = workflow.getHistorySteps(workflowId).iterator();
        
        // Browse the step list to find the newest proposition action.
        if (steps.hasNext())
        {
            steps.next();
            if (steps.hasNext())
            {
                String caller = steps.next().getCaller();
                users.add(UserIdentity.stringToUserIdentity(caller));
            }
        }
        
        return users;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_SEND_MAIL_TO_USER_FUNCTION_LABEL");
    }
}
