/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetCatalogList
extends ServiceableAction {
    protected OdfPageHandler _odfRootHandler;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._odfRootHandler = (OdfPageHandler)((Object)serviceManager.lookup(OdfPageHandler.ROLE));
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String id = request.getParameter("id");
        Page page = (Page)this._resolver.resolveById(id);
        Set unavailableCatalogs = this._odfRootHandler.getOdfRootPages(page.getSiteName(), page.getSitemapName()).stream().filter(odfRootpage -> !page.equals(odfRootpage)).map(this._odfRootHandler::getCatalog).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        List catalogList = this._odfRootHandler.getCatalogs().entrySet().stream().filter(catalogEntry -> !unavailableCatalogs.contains(catalogEntry.getKey())).map(this::getCatalogData).collect(Collectors.toList());
        request.setAttribute(JSonReader.OBJECT_TO_READ, catalogList);
        return EMPTY_MAP;
    }

    protected Map<String, Object> getCatalogData(Map.Entry<String, I18nizableText> catalogEntry) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("code", catalogEntry.getKey());
        data.put("label", catalogEntry.getValue());
        return data;
    }
}

