/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.plugins.odfweb.repository.AbstractOdfPage;
import org.ametys.plugins.odfweb.repository.AbstractOdfPageFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;

public abstract class AbstractProgramItemPage<T extends AbstractOdfPageFactory>
extends AbstractOdfPage<T> {
    public AbstractProgramItemPage(Page root, VirtualPageConfiguration configuration, String scheme, T factory) {
        super(root, configuration, scheme, factory);
    }

    @Override
    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    @Override
    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePages) throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    @Override
    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        if (index < 0) {
            throw new AmetysRepositoryException("Child page index cannot be negative");
        }
        AmetysObjectIterator childPages = this.getChildrenPages().iterator();
        try {
            childPages.skip((long)index);
            return (Page)childPages.next();
        }
        catch (NoSuchElementException e) {
            throw new UnknownAmetysObjectException("There's no child page at index " + index + " for page " + this.getId());
        }
    }

    protected abstract ProgramItem getProgramItem();

    public List<ProgramItem> getOdfPath() {
        ArrayList<ProgramItem> path = new ArrayList<ProgramItem>();
        path.add(this.getProgramItem());
        Page parentPage = (Page)this.getParent();
        while (parentPage instanceof AbstractProgramItemPage) {
            AbstractProgramItemPage programItemPage = (AbstractProgramItemPage)parentPage;
            path.add(programItemPage.getProgramItem());
            parentPage = (Page)parentPage.getParent();
        }
        Collections.reverse(path);
        return path;
    }

    protected void setCurrentEducationalPaths(ProgramItem programItem) {
        List educationalPaths = ((AbstractOdfPageFactory)this._factory)._odfHelper.getEducationalPaths(programItem, true, true);
        List currentEducationalPaths = educationalPaths.stream().filter(this::_isPartOfCurrentPath).collect(Collectors.toList());
        if (!currentEducationalPaths.isEmpty()) {
            if (programItem instanceof Course) {
                Course course = (Course)programItem;
                course.setCurrentEducationalPaths(currentEducationalPaths);
            } else if (programItem instanceof AbstractProgram) {
                AbstractProgram abstractProgram = (AbstractProgram)programItem;
                abstractProgram.setCurrentEducationalPaths(currentEducationalPaths);
            }
        }
    }

    private boolean _isPartOfCurrentPath(EducationalPath path) {
        List<ProgramItem> currentOdfPathInSitemap = this.getOdfPath();
        List<ProgramItem> filteredProgramItemIds = path.getProgramItems(((AbstractOdfPageFactory)this._factory).getResolver()).stream().filter(pi -> pi instanceof AbstractProgram || pi instanceof Course).toList();
        return currentOdfPathInSitemap.equals(filteredProgramItemIds);
    }
}

