/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const PARAM_CRITERIA = "criteria";
const PARAM_FACETS = "facets";
const OLD_INDEXING_FIED_NAME = "CourseSearchable$indexingField$org.ametys.plugins.odf.Content.course$orgUnit";
const NEW_INDEXING_FIED_NAME = "CourseSearchable$indexingField$org.ametys.plugins.odf.Content.programItem$orgUnit";
const XPATH = "//element(*, ametys:zoneItem)[@ametys-internal:type = 'SERVICE' and @ametys-internal:service = 'org.ametys.web.service.SearchService']";

__renameOrgunitFieldInSearchServices(Repository.session);
__renameOrgunitFieldInSearchServices(Repository.liveSession);

function __renameOrgunitFieldInSearchServices(session)
{
    let zoneItems = Repository.query(XPATH, false, session);
    let totalZoneItems = zoneItems.getSize();
    logger.info("[" + session.getWorkspace().getName() + "] " + totalZoneItems + " search services have to be checked.");
    
    let count = 0;
    
    Repository.query(XPATH, true, session).forEach(function(zoneItem) {
	    let params = zoneItem.getServiceParameters(); 
        let hasChanges = false;
        if (params.hasValue(PARAM_CRITERIA))
        {
            let oldCriteriaValue = params.getValue(PARAM_CRITERIA);
            if (oldCriteriaValue.indexOf(OLD_INDEXING_FIED_NAME) != -1)
            {
	            let newCriteriaValue = oldCriteriaValue.replaceAll(OLD_INDEXING_FIED_NAME, NEW_INDEXING_FIED_NAME);
	            params.setValue(PARAM_CRITERIA, newCriteriaValue);
                hasChanges = true;
            }
        }
        
        if (params.hasValue(PARAM_FACETS))
        {
            let oldFacetsValues = params.getValue(PARAM_FACETS);
            let newFacetsValues = [];
            let facetsUpdated = false;
            for (var i=0; i < oldFacetsValues.length; i++)
            {
                if (oldFacetsValues[i].indexOf(OLD_INDEXING_FIED_NAME) != -1)
	            {
	                newFacetsValues.push(oldFacetsValues[i].replaceAll(OLD_INDEXING_FIED_NAME, NEW_INDEXING_FIED_NAME));
                    facetsUpdated = true;
	            }
                else
                {
                    newFacetsValues.push(oldFacetsValues[i]);
                }
            }
            
            if (facetsUpdated)
            {
                Repository.helper.setModelAwareValue(params, PARAM_FACETS, newFacetsValues);
                hasChanges = true;
            }
        }
        
        if (hasChanges)
            count++;
	});

    if (count > 0)
    {
        session.save();
    }
    
    logger.info("[" + session.getWorkspace().getName() + "] " + count + " search services have been migrated.");
}



