<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                extension-element-prefixes="math">
    
    
    <xsl:import href="service:odf-web://pages/services/search/search_1.2.xsl"/>
    <xsl:import href="service:odf-web://pages/services/search/search-criteria/search-criteria-links_1.3.xsl"/>
 
 	<!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:choose>
			<xsl:when test="$search-mode = 'criteria-only' or $search-mode = 'criteria-and-results' or count(hits/hit) = 0">
				<xsl:call-template name="form-criteria"/>
			</xsl:when>
			<xsl:otherwise>
                <xsl:call-template name="back-button"/>                          
			</xsl:otherwise>
    	</xsl:choose>
		
        <xsl:if test="$search-mode = 'criteria-and-results' or $search-mode = 'criteria-or-results'">
            <xsl:call-template name="form-result"/>
        </xsl:if>
    </xsl:template> 
            
</xsl:stylesheet>
