<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:url-encode="java.net.URLEncoder"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="math str url-encode">
                
        
    <xsl:import href="service:odf-web://pages/services/search/search-criteria/search-criteria_1.2.xsl"/>
    
    <xsl:variable name="search-mode">
        <xsl:choose>
            <xsl:when test="/search/force-criteria-display = 'true'">criteria-and-results</xsl:when>
            <xsl:otherwise><xsl:value-of select="ametys:serviceParameter('search-mode')/text()"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="nbPages"><xsl:value-of select="count(/search/pagination/page)"/></xsl:variable>
    <xsl:variable name="current-page" select="xalan:nodeset(/search/pagination/page[@start = ../@start])"></xsl:variable>    
    <xsl:variable name="displaySubProgram" select="ametys:serviceParameter('displaySubProgram')"/>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:choose>
            <xsl:when test="$search-mode = 'criteria-only' or $search-mode = 'criteria-and-results' or count(hits/hit) = 0">
                <xsl:call-template name="form-criteria"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="back-button"/>                          
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:if test="$search-mode = 'criteria-and-results' or $search-mode = 'criteria-or-results'">
            <xsl:call-template name="form-result"/>
        </xsl:if>
    </xsl:template> 
    
    <xsl:template name="form-result">
        <xsl:variable name="raw-is-title-visible"><xsl:call-template name="common-service-body-nonempty-content-title"/></xsl:variable>
        <xsl:variable name="level">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>   
        
        
        <form action="{$site-uri-prefix}/{/search/url}#nav" method="post" class="search-result">
            <div>
                <xsl:call-template name="form-search-hidden"/>
    
                <a name="nav"/>
                
                <xsl:if test="hits/hit">
                    <xsl:element name="h{$level}"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_RESULTS" i18n:catalogue="plugin.odf-web"/></xsl:element>          
                </xsl:if>
                
                <xsl:if test="hits/hit">
                    <xsl:call-template name="results-sort"/>
                </xsl:if>
            </div>
        </form> 
        
        <div class="clear-B"><xsl:comment>empty</xsl:comment></div>        
        
        <div class="results-placeholder">
            <xsl:choose>
                <xsl:when test="hits/hit">
                    <xsl:call-template name="hits"/>
                    <xsl:call-template name="pagination"/>
                </xsl:when>
                <xsl:when test="/search/form/values and not(/search/illegal-textfield)">
                    <!-- Template for no result -->
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="no-result">
        <div class="no-result">
            <p><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NO_RESULT" i18n:catalogue="plugin.odf-web"/></p> 
        </div>     
    </xsl:template>
    
    <!-- +
         | Template for results
         + -->
    <xsl:template name="hits">
        <div class="results">
            <ul>
                <xsl:for-each select="/search/hits/hit">
                    <li>
                        <xsl:attribute name="class">hit page<xsl:text> </xsl:text>
                            <xsl:call-template name="common-utils-class"/>                        
                        </xsl:attribute>                    
                        <a title="{title}">
                            <xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
                            <xsl:value-of select="title"/>
                        </a>
                        <xsl:call-template name="hit-scoring"/>          
                        <xsl:call-template name="excerpt"/>  
                        <xsl:call-template name="hit-lastvalidation"/>  
                        <xsl:call-template name="hit-subprograms"/>                                           
                    </li>
                </xsl:for-each>                            
            </ul>
        </div>    
    </xsl:template>    
    
     <!-- Template used to display the relevance -->
    <xsl:template name="hit-scoring">
        <span class="relevance"><xsl:value-of select="percent"/>%</span>
    </xsl:template>
    
    <!-- Template used to display the validation date of the page -->
    <xsl:template name="hit-lastvalidation">
        <xsl:if test="lastValidation">
            <div class="service-search-validationdate"><i18n:text i18n:key="FRONT_MODULE_SEARCH_PUBLISH_DATE" i18n:catalogue="plugin.web"/><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="long" value="{lastValidation}"/></div>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="hit-subprograms">
        <xsl:param name="class">custom</xsl:param>
        
    	<xsl:if test="$displaySubProgram != 'none' and subprogram">
            <xsl:if test="subprogram[not(@highlight) or @highlight = 'true']">
                <ul class="{$class} subprogram">
                    <xsl:for-each select="subprogram[not(@highlight) or @highlight = 'true']">
                        <li>
                           <xsl:if test="@highlight = 'true'"><xsl:attribute name="class">highlight</xsl:attribute></xsl:if>
                           <xsl:call-template name="hit-subprogram" />
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:if>
            
            <xsl:call-template name="hit-subprograms-others">
                <xsl:with-param name="class" select="$class"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-subprograms-others">
        <xsl:param name="class">custom</xsl:param>
        
        <xsl:if test="$displaySubProgram = 'all_with_highlight' and subprogram[@highlight = 'false']">
            <div class="other-subprograms">
                <a class="collapsed" href="#" onclick="$j(this).toggleClass('collapsed')">
                    <span>
                        <xsl:choose>
                            <xsl:when test="subprogram[@highlight = 'true']">
                                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NOT_MATCHING_SUBPROGRAM_OTHERS" i18n:catalogue="plugin.odf-web"/>   
                            </xsl:when>
                            <xsl:otherwise>
                                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NOT_MATCHING_SUBPROGRAM_SEE" i18n:catalogue="plugin.odf-web"/>   
                            </xsl:otherwise>
                        </xsl:choose>
                    </span>
                </a>
                <ul id="other-subprograms-{$uniqueId}-{position()}" class="{$class} subprogram others">
                    <xsl:for-each select="subprogram[@highlight = 'false']">
                        <li>
                           <xsl:call-template name="hit-subprogram" />
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-subprogram" >
         <a>
            <xsl:attribute name="href">
                <xsl:call-template name="hit-href">
                    <xsl:with-param name="url" select="concat(../uri, '/', @path)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:value-of select="@title"/>
         </a>
    </xsl:template>
    
    <xsl:template name="excerpt">
        <xsl:if test="excerpt">
            <div class="service-search-excerpt">
                <xsl:value-of select="excerpt"/>
            </div> 
        </xsl:if>    
    </xsl:template>
    
    <!-- +
         | Template for results sort
         + -->
    <xsl:template name="results-sort">
        <div class="results-sort">
            <span><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY"/></span>
            <ul>
                <li>
                    <xsl:choose>
                        <xsl:when test="/search/sort-by-score">
                            <span class="current"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_SCORE"/></span>
                        </xsl:when>
                        <xsl:otherwise>
                               <xsl:call-template name="common-utils-input-submit">
                                   <xsl:with-param name="class-name">sort</xsl:with-param>
                                   <xsl:with-param name="i18nkey" select="'plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_SCORE'" />
                                   <xsl:with-param name="name">sort-by-score</xsl:with-param>
                               </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </li>
                <li>
                    <xsl:choose>
                        <xsl:when test="/search/sort-by-title_sort">
                            <span class="current"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_TITLE"/></span>
                        </xsl:when>
                        <xsl:otherwise>
                               <xsl:call-template name="common-utils-input-submit">
                                   <xsl:with-param name="class-name">sort</xsl:with-param>
                                   <xsl:with-param name="i18nkey" select="'plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_TITLE'" />
                                   <xsl:with-param name="name">sort-by-title_sort</xsl:with-param>
                               </xsl:call-template>                        
                        </xsl:otherwise>
                    </xsl:choose>
                </li>
            </ul>
        </div>
    </xsl:template>
    
    <!-- +
         | Template for page navigation
         + -->
    <xsl:template name="pagination">
        <form id="reload" method="post" action="{$site-uri-prefix}/{/search/url}#nav" accept-charset="UTF-8">
            <div class="pagination">
                <xsl:call-template name="pagination-input-hidden"/>
                            
                <xsl:call-template name="common-utils-pagination-results">
                    <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_RESULTS'" />
                    <xsl:with-param name="pagination-start" select="/search/pagination/@start + 1" />
                    <xsl:with-param name="pagination-end" select="/search/pagination/@end" />
                    <xsl:with-param name="hits-total" select="/search/hits/@total" />
                </xsl:call-template>
            
                <xsl:call-template name="common-utils-pagination">
                    <xsl:with-param name="nbPages" select="count(/search/pagination/page)"/>
                    <xsl:with-param name="current-page" select="xalan:nodeset(/search/pagination/page[@start = ../@start])"/>
                </xsl:call-template>            
            </div>
        
        </form>
    </xsl:template>
    
    <xsl:template name="pagination-input-hidden">
        <input type="hidden" name="submit-form">
            <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
            </xsl:if>
        </input>
        <xsl:if test="/search/zone-item/@id">
            <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
        </xsl:if>
        
        <xsl:for-each select="/search/form/values/*[local-name() != 'metadata']">
            <input type="hidden" name="{name()}" value="{.}"/>
        </xsl:for-each>
        
        <!-- Metadata -->
        <xsl:for-each select="/search/form/fields/metadata">
            <xsl:for-each select="/search/form/values/metadata/metadata[@name = current()/@name]">
                <input type="hidden" name="metadata-{translate(@name, '/', '.')}" value="{.}"/>
            </xsl:for-each>
        </xsl:for-each>
        
        <!-- Catalog -->
        <input type="hidden" name="catalog" value="{$catalog}"/>
        
        <xsl:choose>
            <xsl:when test="/search/sort-by-title_sort">
                <input type="hidden" name="sort-by-title_sort"/>
            </xsl:when>
            <xsl:otherwise />
        </xsl:choose>
    </xsl:template>    
    
    <!-- +
         | Template for search form (mode hidden)
         + -->
    <xsl:template name="form-search-hidden">
        <input type="hidden" name="submit-form">
            <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
            </xsl:if>
        </input>
        <xsl:if test="/search/zone-item/@id">
            <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
        </xsl:if>
        
        <xsl:for-each select="/search/form/values/*[local-name() != 'metadata']">
            <input type="hidden" name="{name()}" value="{.}"/>
        </xsl:for-each>
        
        <!-- Metadata -->
        <xsl:for-each select="/search/form/fields/metadata">
            <xsl:for-each select="/search/form/values/metadata/metadata[@name = current()/@name]">
                <input type="hidden" name="metadata-{translate(@name, '/', '.')}" value="{.}"/>
            </xsl:for-each>
        </xsl:for-each>
        
        <!-- Catalog -->
        <input type="hidden" name="catalog" value="{$catalog}"/>
    </xsl:template>
    
    <!-- Template used by back button -->
     <xsl:template name="back-button">
        <div class="back">
            <a href="{$site-uri-prefix}/{url}" title="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_NEW_SEARCH_TITLE" i18n:attr="title">
                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NEW_SEARCH" i18n:catalogue="plugin.odf-web"/>
            </a>
        </div>      
     </xsl:template>
     
     <xsl:template name="hit-href">
        <xsl:param name="url" select="uri"/>
        
        <xsl:value-of select="$site-uri-prefix"/><xsl:text>/</xsl:text><xsl:value-of select="$url"/><xsl:text>.html</xsl:text>
        <xsl:if test="/search/form/values/textfield != '' or /search/form/values/all-words != '' or /search/form/values/exact-wording != ''">
            <xsl:choose>
                <xsl:when test="contains(uri, '?')">&amp;</xsl:when>
                <xsl:otherwise>?</xsl:otherwise>
            </xsl:choose>
            <xsl:text>search-keywords=</xsl:text>
            <xsl:if test="/search/form/values/textfield != ''"><xsl:value-of select="url-encode:encode(/search/form/values/textfield)"/></xsl:if>
            <xsl:if test="/search/form/values/all-words != ''">
                <xsl:if test="/search/form/values/textfield != ''">,</xsl:if>
                <xsl:for-each select="str:split(/search/form/values/all-words)">
                    <xsl:if test="position() &gt; 1">,</xsl:if>
                    <xsl:value-of select="url-encode:encode(.)"/>
                </xsl:for-each>
            </xsl:if>
            <xsl:if test="/search/form/values/exact-wording != ''">
                <xsl:if test="/search/form/values/textfield != '' or /search/form/values/all-words != ''">,</xsl:if>
                <xsl:value-of select="url-encode:encode(/search/form/values/exact-wording)"/>
            </xsl:if>
        </xsl:if>
     </xsl:template>
</xsl:stylesheet>
