/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Update the form list according the selected criteria
 * @param url The update url
 * @param siteName The current site name
 * @param lang The current language
 * @param uniqueId A unique id
 * @param zoneItemId The zone item id
 */
function updateFormLists (url, siteName, lang, catalog, uniqueId, zoneItemId)
{
	function updateCb(data)
	{
		// Iterates on list criteria
		$j('> form > fields > criterion', data).each (function() {
			
			// Get corresponding select field
			var selectField = $j('#search-' + $j(this).attr('name') + '-' + uniqueId),
				selectedValue = selectField.val();
			
			// Removes entries and populate the select field with entries in alphabetical order.
			selectField.empty();
			
			// all option
			selectField.append('<option value=""></option>');
			
			// Update list options
			$j(this).children().sort(sortTextFn).each(function() {
				var count = $j(this).attr('count');
				var optVal = $j(this).attr('value');
				
				if (parseInt(count) != 0 || selectedValue == optVal)
				{
					var option = $j('option[value="' + optVal + '"]', selectField);
						
					// Update option label with new count
					var optLabel = $j(this).text() + ' (' + count + ')';
					
					selectField.append('<option value="' + optVal + '">' + optLabel + '</option>');
				}
			});
					
			// Update the "All" option
			var totalCount = $j(this).attr('count') || 0,
				allOption = $j('option[value=""]', selectField);
			allOption.text(Ext.String.format("{{i18n plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_ALL_FACETS}}", totalCount));
				
			// select the previous value
			selectField.val(selectedValue);
					
			// Send a message to notify that the select data has changed.
			selectField.trigger('changeSelectData');
		});
	}
	
    function isLocaleCompareAvailable()
    {
        try
        {
            "a".localeCompare("b");
            return true;
        }
        catch (e)
        {
            return false;
        }
    }
    
    function localeCompareSortTextFn(a, b)
    {
        return $j(a).text().toLowerCase().localeCompare($j(b).text().toLowerCase());
    }
    
    function basicSortTextFn(a, b)
    {
        return $j(a).text().toLowerCase() < $j(b).text().toLowerCase() ? -1 : 1;
    }
    
    // best effort alphabetical sort
    var sortTextFn = (function ()
    {
        return isLocaleCompareAvailable() ? localeCompareSortTextFn : basicSortTextFn;
    })();
    
	var form = $j('#search-program-' + uniqueId);
	
	var params = _getFormValues(form[0]);
	params.siteName = siteName;
	params.lang = lang;
	params['zone-item-id'] = zoneItemId;
    params.zoneItemId = zoneItemId; // seems useless
	params.catalog = catalog;
	
	$j.post(url, params, updateCb)
}

/**
 * Retrieves the form parameters in a Map
 * @param form the form
 */
function _getFormValues (form)
{
    var params = {};
    
    for (var i = 0; i < form.elements.length; i++)
    {
        var elt = form.elements[i];
        if (elt.name != '' && elt.value != '')
        {
        	params[elt.name] = elt.value;
        }
    }
    
    return params;
}

