<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
            xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
            xmlns:math="http://exslt.org/math"
            xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
            exclude-result-prefixes="escaper math resolver ametys odf">

    <xsl:import href="plugin:web://stylesheets/helper/common.xsl"/>
    
    <xsl:variable name="uniqueId" select="concat('cart_', substring-after(math:random(), '.'))"/>
    
    <!-- + 
         | This helper add a link to open the cart of programs and courses. 
         | You can override the link content through 'link-content' parameter.
         | The link is displayed only if there is a page tagged with 'ODF_CART' tag.
         | The link displayed a counter with the number of elements added to cart (javascript only)
         + -->
    <xsl:template name="goto-cart">
        <xsl:param name="link-content"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_SEE" i18n:catalogue="plugin.odf-web"/></xsl:param>

	    <xsl:variable name="cartPagesIds" select="ametys:findPagesIdsByTag('ODF_CART')"/>
        <xsl:if test="$cartPagesIds">
            <div class="gotocart">
                <a id="gotocart-{$uniqueId}" href="{resolver:resolve('page', $cartPagesIds/@id)}">
                    <xsl:copy-of select="$link-content"/>
                    <span class="cart-counter" id="cart-counter-{$uniqueId}" style="display:none"></span>
                </a>
                <xsl:call-template name="cart-preview">
                    <xsl:with-param name="cartPageId" select="$cartPagesIds/@id"/>
                </xsl:call-template>
            </div>
            
            <script type="text/javascript">
                $j(document).ready(function() {
                
                    function _updateCartCounter(count)
                    {
                        if (count &gt; 0)
                        {
                            $j('.cart-counter').show();
                            $j('.cart-counter').html(count);
                        }
                    }
                    
                    ODFCart.getItemsCount(_updateCartCounter);
                });
            </script>    
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="cart-preview">
        <xsl:param name="cartPageId"/>
        
        <div class="odf-cart-preview" id="odf-cart-preview">
            <div class="odf-cart-preview-buttons">
                <a href="{resolver:resolve('page', $cartPageId)}"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SEE" i18n:catalogue="plugin.odf-web"/></a>
                <a href="javascript:ODFCart.download('{ametys:site()}')"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_DOWNLOAD" i18n:catalogue="plugin.odf-web"/></a>
            </div>
        </div>
        
        <xsl:call-template name="cart-item-preview-template"/>
        
        <script type="text/javascript">
            $j(document).ready(function() {
            
                function _updateCartPreview(items)
                {
                    if (items.length > 0)
                    {
                        var template = $j("#cart-item-preview-template").html();
                        $j('#odf-cart-preview').addClass('non-empty');
                        $j('#odf-cart-preview').prepend('&lt;ul class="odf-cart-preview-items"&gt;&lt;/ul&gt;');
                        var previewWrap = $j('#odf-cart-preview').find('.odf-cart-preview-items');
                        
                        $j(items).each(function(index, item) {
                           var html = template.replace(/{{title}}/ig, item.title)
                                .replace(/{{pageTitle}}/ig, item.pageTitle)
                                .replace(/{{pagePath}}/ig, "<xsl:value-of select="ametys:siteUriPrefix()"/>/<xsl:value-of select="ametys:lang()"/>/" + item.pagePath + ".html")
                                .replace(/{{id}}/ig, item.id)
                                .replace(/{{contentTypeLabel}}/ig, item.contentTypeLabel)
                                .replace(/{{parentProgramTitle}}/ig, item.parentProgramTitle ? item.parentProgramTitle : '')
                                .replace(/{{view}}/ig, item.view ? item.view : '');
                                
                           previewWrap.append(html);
                        });
                    }
                }
                
                ODFCart.getItems('<xsl:value-of select="ametys:lang()"/>', 'cart', _updateCartPreview);
            });
        </script>  
    </xsl:template>
    
    <xsl:template name="cart-item-preview-template">
        <script id="cart-item-preview-template" type="text/template">
            <li class="odf-cart-preview-item">
                <div class="odf-cart-preview-item-elmt">
                    <span data-parent-title="{{{{parentProgramTitle}}}}" class="odf-cart-preview-item-elmt-parent">{{parentProgramTitle}}</span>
                    <a href="{{{{pagePath}}}}">{{title}}</a>
                    <span class="odf-cart-preview-item-elmt-type">{{contentTypeLabel}}</span>
                </div>
                <div class="odf-cart-preview-item-action">
                    <button class="cart-item-preview-remove" type="button" onclick="ODFCart.removeItem('{{{{id}}}}')">×</button>
                </div>
            </li>
        </script>
    </xsl:template>
    
    <!-- +
         | This helper add a link to add a ODF content to the cart (JS only).
         | You can override the link content through 'link-content' parameter.
         + -->
    <xsl:template name="add-to-cart">
        <xsl:param name="link-content"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_ADD" i18n:catalogue="plugin.odf-web"/></xsl:param>
        <xsl:param name="link-content-remove"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_DELETE" i18n:catalogue="plugin.odf-web"/></xsl:param>
    
        <xsl:call-template name="add-to-cart-html">
        	<xsl:with-param name="link-content" select="$link-content"/>
        	<xsl:with-param name="link-content-remove" select="$link-content-remove"/>
        </xsl:call-template>
        
        <xsl:call-template name="add-to-cart-js"/>
    </xsl:template>
    
    <xsl:template name="add-to-cart-html">
        <xsl:param name="link-content"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_ADD" i18n:catalogue="plugin.odf-web"/></xsl:param>
        <xsl:param name="link-content-remove"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_DELETE" i18n:catalogue="plugin.odf-web"/></xsl:param>
        
        <xsl:variable name="itemId"><xsl:call-template name="compute-cartitem-id"/></xsl:variable>
        <div class="add-to-cart" id="add-to-cart-{$uniqueId}" style="display:none">
            <a href="javascript:ODFCart.addItem('{$itemId}', '{escaper:escapeJavaScript(@title)}');">
	            <xsl:copy-of select="$link-content"/>
            </a>
        </div>
        <div class="remove-from-cart" id="remove-from-cart-{$uniqueId}" style="display:none">
            <a href="javascript:ODFCart.removeItem('{$itemId}')">
	            <xsl:copy-of select="$link-content-remove"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="compute-cartitem-id">
        <xsl:choose>
            <xsl:when test="ametys:contentTypes(@id)[@id = 'org.ametys.plugins.odf.Content.subProgram']">
                <xsl:variable name="parentProgramId" select="odf:parentProgramId()"/>
                <xsl:choose>
                    <xsl:when test="$parentProgramId != ''"><xsl:value-of select="concat(@id, ';', $parentProgramId)"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="add-to-cart-js">
        <script type="text/javascript">
            $j(document).ready(function() {
                function _updateLinks(answer)
                {
                    if (answer)
                    {
                        $j(".remove-from-cart").show();
                        $j(".add-to-cart").hide();
                    }
                    else
                    {
                        $j(".remove-from-cart").hide();
                        $j(".add-to-cart").show();
                    }
                }
                
                <xsl:variable name="itemId"><xsl:call-template name="compute-cartitem-id"/></xsl:variable>
                ODFCart.hasItem('<xsl:value-of select="$itemId"/>', _updateLinks);
            });
        </script>
    </xsl:template>
    
</xsl:stylesheet>