/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.actions;

import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.config.Config;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetCourseForIPWebAction
extends ServiceableAction {
    private CatalogsManager _catalogsManager;
    private OdfPageResolver _odfPageResolver;
    private ContentTypeExtensionPoint _contentTypeEP;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._catalogsManager = (CatalogsManager)smanager.lookup(CatalogsManager.ROLE);
        this._odfPageResolver = (OdfPageResolver)((Object)smanager.lookup(OdfPageResolver.ROLE));
        this._contentTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (!((Boolean)Config.getInstance().getValue("odf.ipweb.activate", true, (Object)false)).booleanValue()) {
            throw new UnsupportedOperationException("The IPWeb URL resolution is not configured.");
        }
        String field = this.getField();
        String lang = this.getLanguage();
        String catalog = this.getCatalog();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String courseCode = request.getParameter("CodElp");
        Course course = this.searchCourse(catalog, lang, courseCode, field);
        String url = this.resolvePage(request, course, field);
        redirector.redirect(false, url);
        return EMPTY_MAP;
    }

    private String getField() throws ResourceNotFoundException {
        String field = (String)Config.getInstance().getValue("odf.ipweb.field");
        if (!((ContentType)this._contentTypeEP.getExtension("org.ametys.plugins.odf.Content.course")).hasModelItem(field)) {
            throw new ResourceNotFoundException(String.format("The field '%s' is not defined on course type.", field));
        }
        return field;
    }

    private String getLanguage() {
        return Optional.of("odf.ipweb.lang").map(arg_0 -> ((Config)Config.getInstance()).getValue(arg_0)).filter(StringUtils::isNotEmpty).orElseGet(() -> (String)Config.getInstance().getValue("odf.programs.lang"));
    }

    private String getCatalog() throws ResourceNotFoundException {
        String catalog = Optional.of("odf.ipweb.catalog").map(arg_0 -> ((Config)Config.getInstance()).getValue(arg_0)).filter(StringUtils::isNotEmpty).orElseGet(() -> ((CatalogsManager)this._catalogsManager).getDefaultCatalogName());
        if (this._catalogsManager.getCatalog(catalog) == null) {
            throw new ResourceNotFoundException(String.format("The catalog '%s' does not exist", catalog));
        }
        return catalog;
    }

    private Course searchCourse(String catalog, String lang, String code, String fieldCode) throws ResourceNotFoundException {
        AndExpression expression = new AndExpression(new Expression[0]);
        expression.add((Object)new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.course"}));
        expression.add((Object)new StringExpression("catalog", Expression.Operator.EQ, catalog));
        expression.add((Object)new LanguageExpression(Expression.Operator.EQ, lang));
        expression.add((Object)new StringExpression(fieldCode, Expression.Operator.EQ, code));
        String xpathQuery = ContentQueryHelper.getContentXPathQuery((Expression)expression);
        AmetysObjectIterable courses = this._resolver.query(xpathQuery);
        if (courses.getSize() > 1L) {
            throw new ResourceNotFoundException(String.format("There are several courses with %s '%s' in catalog '%s' with language '%s'", fieldCode, code, catalog, lang));
        }
        Course course = courses.stream().findFirst().orElse(null);
        if (course == null) {
            throw new ResourceNotFoundException(String.format("There is no course with %s '%s' in catalog '%s' with language '%s'", fieldCode, code, catalog, lang));
        }
        return course;
    }

    private String resolvePage(Request request, Course course, String field) throws ResourceNotFoundException {
        String siteName = WebHelper.getSiteName((Request)request);
        CoursePage page = this._odfPageResolver.getCoursePage(course, (AbstractProgram)null, siteName);
        if (page == null) {
            throw new ResourceNotFoundException(String.format("There is no page for course with code '%s' in catalog '%s' with language '%s' on site '%s'", course.getValue(field), course.getCatalog(), course.getLanguage(), siteName));
        }
        return ResolveURIComponent.resolve((String)"page", (String)page.getId(), (boolean)false, (boolean)true, (boolean)false);
    }
}

