/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cachepolicy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.observation.Event;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.person.Person;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.pageelement.PageElementCachePolicy;
import org.ametys.web.inputdata.SitemapInputData;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class OdfVirtualPagesCachePolicy
extends AbstractLogEnabled
implements Serviceable,
PageElementCachePolicy {
    private static final Set<String> _ODF_PE_TYPES = new HashSet<String>();
    protected OdfPageHandler _odfRootPageHandler;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfRootPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
    }

    public Set<String> getPageElementTypes() {
        return _ODF_PE_TYPES;
    }

    public final PageElementCachePolicy.PolicyResult shouldClearCache(String workspace, Site site, String pageElementType, Event event) {
        Object object;
        Map args;
        String id = event.getId();
        if (this._getRemovingCacheEventIds(workspace).contains(id) && (args = event.getArguments()).containsKey("content") && ((object = args.get("content")) instanceof ProgramItem || object instanceof CoursePart || object instanceof OrgUnit || object instanceof Person) && this._odfRootPageHandler.hasOdfRootPage(site)) {
            return PageElementCachePolicy.PolicyResult.REMOVE;
        }
        return PageElementCachePolicy.PolicyResult.KEEP;
    }

    public final PageElementCachePolicy.PolicyResult shouldClearCache(String workspace, Site site, String pageElementType, String elementId, Event event) {
        throw new UnsupportedOperationException("Should never be called.");
    }

    protected List<String> _getRemovingCacheEventIds(String workspace) {
        if ("default".equals(workspace)) {
            return Arrays.asList("content.added", "content.modified", "content.deleted", "odf.content.skills.exclusion.changed");
        }
        if ("live".equals(workspace)) {
            return Arrays.asList("content.added", "content.validated", "content.deleted", "content.untag.live", "odf.content.skills.exclusion.changed");
        }
        return Collections.emptyList();
    }

    static {
        _ODF_PE_TYPES.add(SitemapInputData.class.getName());
        _ODF_PE_TYPES.add("SERVICE:org.ametys.web.service.SitemapService");
        _ODF_PE_TYPES.add("CONTENT");
    }
}

