/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.repository.Content;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.odfweb.service.search.MatchingSubprogramSearchComponent;
import org.ametys.plugins.odfweb.service.search.ProgramReturnable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.web.frontoffice.search.metamodel.impl.PageReturnable;
import org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProgramSaxer
extends PageSaxer {
    private ProgramReturnable _programReturnable;
    private ProgramReturnable.DisplaySubprogramMode _displaySubprogramMode;

    public ProgramSaxer(PageReturnable pageReturnable, ProgramReturnable programReturnable, ProgramReturnable.DisplaySubprogramMode displaySubprogramMode) {
        super(pageReturnable);
        this._programReturnable = programReturnable;
        this._displaySubprogramMode = displaySubprogramMode;
    }

    public boolean canSax(AmetysObject hit, Logger logger, SearchComponentArguments args) {
        return hit instanceof Program;
    }

    public void sax(ContentHandler contentHandler, AmetysObject hit, Logger logger, SearchComponentArguments args) throws SAXException {
        Request request = ContextHelper.getRequest((Context)this._programReturnable._avalonContext);
        Program program = (Program)hit;
        Optional<ProgramPage> programPage = this._resolveProgramPage(program, args.currentSite());
        if (programPage.isPresent()) {
            this._saxProgramPage(contentHandler, programPage.get(), logger, args);
        } else {
            logger.warn("The program {} was returned from the search but its ProgramPage could not be resolved", (Object)program);
            String sitemapName = args.currentPage().getSitemapName();
            this._saxProgramWithNoPage(contentHandler, program, sitemapName, logger);
        }
        this.saxSubPrograms(contentHandler, program, programPage, logger, request);
    }

    private Optional<ProgramPage> _resolveProgramPage(Program program, Site currentSite) {
        return Optional.of(this._programReturnable._getOdfPageResolver()).map(res -> res.getProgramPage(program, currentSite.getName()));
    }

    private Optional<Page> _resolveSubProgramPage(Program program, Optional<ProgramPage> programPage, SubProgram subProgram) {
        return programPage.map(AbstractConfigurableVirtualPage::getSiteName).map(siteName -> this._programReturnable._getOdfPageResolver().getSubProgramPage(subProgram, (AbstractProgram)program, (String)siteName));
    }

    private String _getSubProgramPagePath(Page subProgramPage, String programPath) {
        return StringUtils.substringAfterLast((String)subProgramPage.getPathInSitemap(), (String)programPath);
    }

    private void _saxProgramWithNoPage(ContentHandler contentHandler, Program program, String sitemapName, Logger logger) throws SAXException {
        Locale locale = LocaleUtils.toLocale((String)sitemapName);
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"title", (String)program.getTitle());
        this.saxContent((Content)program, "index", locale, contentHandler, logger);
    }

    private void _saxProgramPage(ContentHandler contentHandler, ProgramPage programPage, Logger logger, SearchComponentArguments args) throws SAXException {
        super.sax(contentHandler, (AmetysObject)programPage, logger, args);
    }

    protected void saxSubPrograms(ContentHandler contentHandler, Program program, Optional<ProgramPage> programPage, Logger logger, Request request) throws SAXException {
        if (this._displaySubprogramMode == ProgramReturnable.DisplaySubprogramMode.NONE) {
            return;
        }
        List<String> matchingSubProgramIds = MatchingSubprogramSearchComponent._getMatchingSubProgramIds(request);
        ContentType subProgramCType = (ContentType)this._programReturnable._getContentTypeEP().getExtension("org.ametys.plugins.odf.Content.subProgram");
        View view = subProgramCType.getView("index");
        Optional<String> programPath = programPage.map(ProgramPage::getPathInSitemap);
        for (ProgramPart childProgramPart : program.getProgramPartChildren()) {
            if (!(childProgramPart instanceof SubProgram)) continue;
            SubProgram subProgram = (SubProgram)childProgramPart;
            boolean matchSearch = matchingSubProgramIds.contains(subProgram.getId());
            this.saxSubProgram(contentHandler, subProgram, program, programPage, matchSearch, programPath, logger, view);
        }
    }

    protected void saxSubProgram(ContentHandler contentHandler, SubProgram subProgram, Program program, Optional<ProgramPage> programPage, boolean matchSearch, Optional<String> programPath, Logger logger, View view) throws SAXException {
        if (this._displaySubprogramMode != ProgramReturnable.DisplaySubprogramMode.MATCHING_SEARCH_ONLY || matchSearch) {
            AttributesImpl attrs = new AttributesImpl();
            Optional<Page> subProgramPage = this._resolveSubProgramPage(program, programPage, subProgram);
            if (subProgramPage.isPresent() && programPath.isPresent()) {
                attrs.addCDATAAttribute("path", this._getSubProgramPagePath(subProgramPage.get(), programPath.get()));
            }
            attrs.addCDATAAttribute("id", subProgram.getId());
            attrs.addCDATAAttribute("name", subProgram.getName());
            attrs.addCDATAAttribute("title", subProgram.getTitle());
            if (this._displaySubprogramMode == ProgramReturnable.DisplaySubprogramMode.ALL_WITH_HIGHLIGHT) {
                attrs.addCDATAAttribute("highlight", String.valueOf(matchSearch));
            }
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"subprogram", (Attributes)attrs);
            try {
                subProgram.dataToSAX(contentHandler, (ViewItemAccessor)view);
            }
            catch (Exception e) {
                logger.error("An error occurred during saxing subprogram '" + subProgram.getId() + "' metadata", (Throwable)e);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"subprogram");
        }
    }
}

