/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search.helper;

import java.util.List;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.plugins.odfweb.service.search.criterion.DegreeUniversityCriterionDefinition;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.frontoffice.search.metamodel.SearchServiceCriterionDefinition;
import org.ametys.web.frontoffice.search.metamodel.Searchable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class DegreeUniversityHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
PluginAware {
    public static final String ROLE = DegreeUniversityHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    protected String _pluginName;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public List<Content> getDegrees(boolean isUniversity) {
        StringExpression duExpression = new StringExpression("type", Expression.Operator.EQ, "UNIVERSITY");
        AndExpression expr = new AndExpression(new Expression[]{new ContentTypeExpression(Expression.Operator.EQ, new String[]{"odf-enumeration.Degree"}), isUniversity ? duExpression : new NotExpression((Expression)duExpression)});
        return this._resolver.query(QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)expr)).stream().filter(Content.class::isInstance).map(Content.class::cast).collect(Collectors.toList());
    }

    public SearchServiceCriterionDefinition getDegreeUniversityCriterionDefinition(Searchable searcheable) {
        ContentType programContentType = (ContentType)this._contentTypeExtensionPoint.getExtension("org.ametys.plugins.odf.Content.program");
        ElementDefinition degreeDefinition = (ElementDefinition)programContentType.getModelItem("degree");
        String name = "ProgramSearchable$org.ametys.plugins.odf.Content.program$degree$University";
        DegreeUniversityCriterionDefinition criterionDefinition = new DegreeUniversityCriterionDefinition(degreeDefinition, "degree", programContentType);
        criterionDefinition.setName(name);
        criterionDefinition.setPluginName(this._pluginName);
        criterionDefinition.setSearchable(searcheable);
        return criterionDefinition;
    }
}

