<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
    
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    
    <xsl:param name="format">html</xsl:param>
    
    <xsl:variable name="nl"><xsl:text>
</xsl:text></xsl:variable>

    <xsl:template match="/Mail">
        <body>
            <xsl:choose>
                <xsl:when test="$format = 'html'">
                    <xsl:call-template name="body-html"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="body-text"/>
                </xsl:otherwise>
            </xsl:choose>
        </body>
    </xsl:template>
    
    <xsl:template name="body-html">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_CART_SHARE_MAIL_HTML_BODY_INTRO"/>
            <i18n:param><xsl:value-of select="owner/fullname"/></i18n:param>
            <i18n:param><xsl:value-of select="siteTitle"/></i18n:param>
            <i18n:param><xsl:value-of select="siteUrl"/></i18n:param>
        </i18n:translate>
        <xsl:apply-templates select="message" mode="html"/>&lt;br/&gt;
        <xsl:if test="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.program' or types/type/@id = 'org.ametys.plugins.odf.Content.subProgram']">
            <xsl:text>&lt;br/&gt;</xsl:text>
            <i18n:text i18n:key="PLUGINS_ODFWEB_CART_SHARE_MAIL_CART_PROGRAMS"/>
            <xsl:text>&lt;ul&gt;</xsl:text>
                <xsl:apply-templates select="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.program' or types/type/@id = 'org.ametys.plugins.odf.Content.subProgram']" mode="html">
                    <xsl:sort select="content/@title"/>
                </xsl:apply-templates>
            <xsl:text>&lt;/ul&gt;</xsl:text>
        </xsl:if>
        <xsl:if test="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.course']">
            <xsl:text>&lt;br/&gt;</xsl:text>
            <i18n:text i18n:key="PLUGINS_ODFWEB_CART_SHARE_MAIL_CART_COURSES"/>
            <xsl:text>&lt;ul&gt;</xsl:text>
            <xsl:apply-templates select="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.course']" mode="html">
                <xsl:sort select="content/@title"/>
            </xsl:apply-templates>
            <xsl:text>&lt;/ul&gt;</xsl:text>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="body-text">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_CART_SHARE_MAIL_TEXT_BODY_INTRO"/>
            <i18n:param><xsl:value-of select="owner/fullname"/></i18n:param>
            <i18n:param><xsl:value-of select="siteTitle"/></i18n:param>
            <i18n:param><xsl:value-of select="siteUrl"/></i18n:param>
        </i18n:translate>
        
        <xsl:apply-templates select="message" mode="text"/>
        
        <xsl:if test="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.program' or types/type/@id = 'org.ametys.plugins.odf.Content.subProgram']">
            <xsl:value-of select="$nl"/>
            <i18n:text i18n:key="PLUGINS_ODFWEB_CART_SHARE_MAIL_CART_PROGRAMS"/>
            <xsl:apply-templates select="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.program' or types/type/@id = 'org.ametys.plugins.odf.Content.subProgram']" mode="text">
                <xsl:sort select="content/@title"/>
            </xsl:apply-templates>
        </xsl:if>
        
        <xsl:if test="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.course']">
            <xsl:value-of select="$nl"/>
            <i18n:text i18n:key="PLUGINS_ODFWEB_CART_SHARE_MAIL_CART_COURSES"/>
            <xsl:apply-templates select="items/item[types/type/@id = 'org.ametys.plugins.odf.Content.course']" mode="text">
                <xsl:sort select="content/@title"/>
            </xsl:apply-templates>
        </xsl:if>
        
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_CART_SHARE_MAIL_TEXT_BODY_END"/>
            <i18n:param><xsl:value-of select="siteUrl"/></i18n:param>
            <i18n:param><xsl:value-of select="siteTitle"/></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template match="item" mode="html">
        &lt;li&gt;&lt;a href="<xsl:value-of select="resolver:resolve('page', page/@id, false(), true())"/>"&gt;<xsl:if test="parent"><xsl:value-of select="parent/@title"/>: </xsl:if><xsl:value-of select="content/@title"/>&lt;/a&gt;&lt;/li&gt;
    </xsl:template>
    
    <xsl:template match="item" mode="text">
        <xsl:value-of select="$nl"/>* <xsl:if test="parent"><xsl:value-of select="parent/@title"/>: </xsl:if><xsl:value-of select="content/@title"/> (<xsl:value-of select="resolver:resolve('page', page/@id, false(), true())"/>)
    </xsl:template>
    
    <xsl:template match="message" mode="html">
        <xsl:call-template name="text.nl2br">
            <xsl:with-param name="input" select="text()"/>
            <xsl:with-param name="forjs" select="true()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="message" mode="text">
        <xsl:value-of select="$nl"/><xsl:value-of select="text()"/>
    </xsl:template>
    
</xsl:stylesheet>