<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="ametys">
            
    <xsl:variable name="max-entry-count" select="5"/>
    <xsl:variable name="hide-zero" select="true()"/>
    
    <xsl:template name="js-facets">
        <xsl:if test="$facets">
            <script src="{$uri-prefix}/plugins/odf-web/resources/js/search/facet-checkboxes-multi.{$lang}.js" type="text/javascript"/>
            <script type="text/javascript">
                Ametys.odf.MultiFacets.setupForm(
                    '<xsl:value-of select="$uniqueId"/>',
                    '<xsl:value-of select="$search-form-id"/>',
                    '<xsl:value-of select="concat($uri-prefix, $search-criteria-url)"/>',
                    '<xsl:value-of select="$siteName"/>',
                    '<xsl:value-of select="$lang"/>',
                    '<xsl:value-of select="/search/zone-item/@id"/>',
                    <xsl:value-of select="$max-entry-count"/>,
                    <xsl:value-of select="$hide-zero"/> 
                );
            </script>
        </xsl:if>
    </xsl:template>

	<xsl:template name="form-search-by-metadata-enum">
		<xsl:param name="value" />

		<xsl:variable name="name" select="@name" />
		<div class="field">
			<div class="label label-{$name}">
				<label for="search-metadata-{translate(@name, '/', '-')}-{$uniqueId}">
					<xsl:value-of select="label" />
				</label>
			</div>

			<div class="input" id="search-{$name}-{$uniqueId}">
				<xsl:choose>
					<xsl:when test="$facets">
						<xsl:for-each select="enumeration/item">
							<xsl:sort select="label" />

							<xsl:if test="/search/form/facets/facet[@name = $name]/*[@value = current()/@value]/@count != '0'">
								<div class="field checkbox">
									<div class="input label-after">
										<input type="checkbox" name="metadata-{translate($name, '/', '.')}" value="{@value}" id="search-{translate($name, '/', '-')}-{$uniqueId}-{translate(@value, '/', '-')}">
											<xsl:if test="@value = $value">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>
										</input>
									</div>
									<div class="label">
										<label for="search-{translate($name, '/', '-')}-{$uniqueId}-{translate(@value, '/', '-')}">
											<span><xsl:value-of select="label" /><span class="facet-count"> (<xsl:value-of select="/search/form/facets/facet[@name = $name]/*[@value = current()/@value]/@count" />)</span></span>
										</label>
									</div>
									<div class="field-end"></div>
								</div>
							</xsl:if>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="enumeration/item">
							<xsl:sort select="label" />
							
							<div class="field checkbox">
								<div class="input label-after">
									<input type="checkbox" name="metadata-{translate($name, '/', '.')}" value="{@value}" id="search-{translate($name, '/', '-')}-{$uniqueId}-{translate(@value, '/', '-')}">
										<xsl:if test="@value = $value">
											<xsl:attribute name="checked">checked</xsl:attribute>
										</xsl:if>
									</input>
								</div>
								<div class="label">
									<label for="search-{translate($name, '/', '-')}-{$uniqueId}-{translate(@value, '/', '-')}">
										<span><xsl:value-of select="label" /></span>
									</label>
								</div>
								<div class="field-end"></div>
							</div>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<div class="field-end"></div>
		</div>
	</xsl:template>
    
</xsl:stylesheet>
