/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.cart;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.odfweb.cart.ODFCartManager.ODFCartItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;


/**
 * Generator for cart shared by mail
 *
 */
public class ShareCartMailGenerator extends ServiceableGenerator
{
    private ODFCartManager _odfCartManager;
    private UserHelper _userHelper;
    private SiteManager _siteManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _odfCartManager = (ODFCartManager) smanager.lookup(ODFCartManager.ROLE);
        _userHelper = (UserHelper) smanager.lookup(UserHelper.ROLE);
        _siteManager = (SiteManager) smanager.lookup(SiteManager.ROLE);
    }
    
    @SuppressWarnings("unchecked")
    public void generate() throws IOException, SAXException, ProcessingException
    {
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "Mail");
        
        Map<String, Object> ctxParameters = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        
        UserIdentity owner = (UserIdentity) ctxParameters.get("owner");
        String message = (String) ctxParameters.get("message");
        String siteName = (String) ctxParameters.get("siteName");
        List<ODFCartItem> items = (List<ODFCartItem>) ctxParameters.get("items");
        
        if (owner != null)
        {
            _userHelper.saxUserIdentity(owner, contentHandler, "owner");
        }
        
        if (StringUtils.isNotEmpty(message))
        {
            XMLUtils.createElement(contentHandler, "message", message);
        }
        
        Site site = _siteManager.getSite(siteName);
        XMLUtils.createElement(contentHandler, "siteTitle", site.getTitle());
        XMLUtils.createElement(contentHandler, "siteUrl", site.getUrl());
        
        XMLUtils.startElement(contentHandler, "items");
        for (ODFCartItem item : items)
        {
            _odfCartManager.saxCartItem(contentHandler, item, siteName);
        }
        XMLUtils.endElement(contentHandler, "items");
        
        XMLUtils.endElement(contentHandler, "Mail");
        contentHandler.endDocument();

    }

}
