/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.odfweb.cart.ODFCartManager;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetCartItemViewAction
extends ServiceableAction {
    private ODFCartManager _cartManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cartManager = (ODFCartManager)((Object)smanager.lookup(ODFCartManager.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        String siteName = WebHelper.getSiteName((Request)request);
        String[] itemsIds = request.getParameter("itemIds").split(",");
        String view = request.getParameter("view");
        for (String itemId : itemsIds) {
            ODFCartManager.ODFCartItem item = this._cartManager.getCartItem(itemId);
            if (item != null) {
                items.add(this._cartManager.cartItem2Json(item, siteName, view));
                continue;
            }
            this.getLogger().warn("The cart's item with id '" + itemId + "' does not match existing content. It will be ignored");
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("items", items);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

