/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.AbstractProgramItemPage;
import org.ametys.plugins.odfweb.repository.CoursePageFactory;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang3.StringUtils;

public class CoursePage
extends AbstractProgramItemPage<CoursePageFactory> {
    private Course _course;
    private String _path;
    private Page _parentPage;
    private Program _parentProgram;

    public CoursePage(Page root, VirtualPageConfiguration configuration, CoursePageFactory factory, Course course, Program parentProgram, String path, Page parentPage) {
        super(root, configuration, factory.getScheme(), factory);
        this._course = course;
        this._path = path;
        this._parentPage = parentPage;
        this._parentProgram = parentProgram;
    }

    public Course getCourse() {
        return this._course;
    }

    @Override
    protected ProgramItem getProgramItem() {
        return this.getCourse();
    }

    public int getDepth() throws AmetysRepositoryException {
        int levelDepth = 0;
        if (StringUtils.isNotBlank((CharSequence)((CoursePageFactory)this._factory).getODFPageHandler().getLevel1Metadata(this._root))) {
            ++levelDepth;
            if (StringUtils.isNotBlank((CharSequence)((CoursePageFactory)this._factory).getODFPageHandler().getLevel2Metadata(this._root))) {
                ++levelDepth;
            }
        }
        return this._root.getDepth() + levelDepth + this._path.split("/").length;
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._course.getTitle();
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._course.getTitle();
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        List<CoursePage> children = this._transformChildrenPages(this._traverseCourseLists()).toList();
        return new CollectionIterable(children);
    }

    private CoursePage _createCoursePage(Course course) {
        return ((CoursePageFactory)this._factory).createCoursePage(this._root, course, this._parentProgram, this._path + "/" + this.getName(), (Page)this);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        String path = this._computePath(this._root.getPathInSitemap());
        return path == null ? null : path + "/" + this.getName();
    }

    private Program _getParentProgram() {
        return this._parentProgram;
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        List<String> headQueuePath = Arrays.asList(StringUtils.split((String)path, (String)"/", (int)2));
        String name = headQueuePath.get(0);
        String queuePath = (String)Iterables.get(headQueuePath, (int)1, null);
        return (A)((AmetysObject)this._findChildPage(name).map(cp -> ((CoursePageFactory)this._factory).getODFPageHandler().addRedirectIfNeeded((Page)cp, name)).map(cp -> ((CoursePageFactory)this._factory).getODFPageHandler().exploreQueuePath((Page)cp, queuePath)).orElseThrow(() -> new UnknownAmetysObjectException("Unknown child page '" + path + "' for page " + this.getId())));
    }

    private Optional<CoursePage> _findChildPage(String name) {
        return this._transformChildrenPages(this._traverseCourseLists().filter(child -> this._filterByName((Course)child, name))).findFirst();
    }

    private boolean _filterByName(Course course, String pageName) {
        return course.getCode().equals(pageName.substring(pageName.lastIndexOf("-") + 1));
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return this._findChildPage(name).isPresent();
    }

    public String getId() throws AmetysRepositoryException {
        return "course://" + this._path + "?rootId=" + this._root.getId() + "&courseId=" + this._course.getId() + "&programId=" + this._parentProgram.getId();
    }

    public String getName() throws AmetysRepositoryException {
        return ((CoursePageFactory)this._factory).getODFPageHandler().getPageName((ProgramItem)this._course);
    }

    public Page getParent() throws AmetysRepositoryException {
        String childPath;
        if (this._parentPage == null && (childPath = this._computePath(null)) != null) {
            this._parentPage = childPath.isEmpty() ? this._root : (Page)this._root.getChild(childPath);
        }
        return this._parentPage;
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this._computePath(this._root.getPath());
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((CoursePageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }

    private Stream<Course> _traverseCourseLists() {
        CourseListTraverser traverser = new CourseListTraverser(this._course.getCourseLists());
        return traverser.stream().filter(Course.class::isInstance).map(Course.class::cast);
    }

    public Course getContent() {
        Course course = this.getCourse();
        course.setContextPath(this.getPathInSitemap());
        if (!((CoursePageFactory)this._factory).isIndexing()) {
            this.setCurrentEducationalPaths((ProgramItem)course);
        }
        return course;
    }

    private String _computePath(String rootPath) {
        String levelsPath = ((CoursePageFactory)this._factory).getODFPageHandler().computeLevelsPath(this._root, this._getParentProgram());
        if (levelsPath == null) {
            throw new UnknownAmetysObjectException("Page of program " + this._getParentProgram().getId() + " does not have a valid level path");
        }
        return Stream.of(rootPath, levelsPath, this._path).filter(StringUtils::isNotEmpty).collect(Collectors.joining("/"));
    }

    private Stream<CoursePage> _transformChildrenPages(Stream<Course> children) {
        return children.map(this::_createCoursePage).filter(Objects::nonNull).filter(page -> {
            try {
                page.getPathInSitemap();
                return true;
            }
            catch (UnknownAmetysObjectException e) {
                return false;
            }
        });
    }

    static class CourseListTraverser
    extends ProgramPage.AbstractTreeIterator<ProgramItem> {
        public CourseListTraverser(Collection<? extends ProgramItem> programPartChildren) {
            super(programPartChildren);
        }

        @Override
        protected Iterator<ProgramItem> provideChildIterator(ProgramItem parent) {
            if (parent instanceof CourseList) {
                CourseList courseList = (CourseList)parent;
                return new CourseListTraverser(courseList.getCourses());
            }
            return null;
        }
    }
}

