/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const PARAM_OLD_NAME = "ametys:metadataSetName";
const PARAM_NEW_NAME = "ametys:viewName";
const XPATH = "//element(*, ametys:zoneItem)[@ametys-internal:type = 'SERVICE' and @ametys-internal:service = 'org.ametys.odf.service.InsertProgram']";
 
function __renameInsertProgramServicesViewNameParameter(session)
{
    let zoneItems = Repository.query(XPATH, false, session);
    let totalZoneItems = zoneItems.getSize();
    logger.info("[" + session.getWorkspace().getName() + "] " + totalZoneItems + " insert program services have to be migrated.");
    
    let count = 0;
    while (zoneItems.hasNext())
    {
        let zoneItem = zoneItems.nextNode();
        let params = zoneItem.getNode("ametys:service_parameters");
        if(params.hasProperty(PARAM_OLD_NAME))
        {
            let oldViewNameProperty = params.getProperty(PARAM_OLD_NAME);
            let viewName = oldViewNameProperty.getString();
            
            Repository.helper.setProperty(params, PARAM_NEW_NAME, viewName);
            oldViewNameProperty.remove();
            count++;
            
            logger.debug("[" + session.getWorkspace().getName() + "] insert program service of zone item '" + zoneItem + "' has been migrated.");
        }
    }
    
    if (count > 0)
    {
        session.save();
    }
    
    logger.info("[" + session.getWorkspace().getName() + "] " + count + " insert program services have been migrated.");
}

__renameInsertProgramServicesViewNameParameter(Repository.session);
__renameInsertProgramServicesViewNameParameter(Repository.liveSession);

