/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.search.query.Query;
import org.ametys.cms.transformation.URIResolver;
import org.ametys.cms.transformation.URIResolverExtensionPoint;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.course.Course;
import org.ametys.odf.course.CourseFactory;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.metamodel.ReturnableExtensionPoint;
import org.ametys.web.frontoffice.search.metamodel.ReturnableSaxer;
import org.ametys.web.frontoffice.search.metamodel.impl.AbstractContentBasedReturnable;
import org.ametys.web.frontoffice.search.metamodel.impl.PageReturnable;

/**
 * {@link Returnable} for {@link Course}s
 */
public class CourseReturnable extends AbstractContentBasedReturnable
{
    /** Avalon Role */
    public static final String ROLE = CourseReturnable.class.getName();
    
    /** The prefix for the ids of sorts */
    protected static final String __SORT_DEFINITION_PREFIX_ID = "CourseReturnable$";

    /** The page resolver for ODF */
    protected OdfPageResolver _odfPageResolver;
    /** THe ODF helper */
    protected ODFHelper _odfHelper;
    /** The URI resolver for ODF */
    protected URIResolver _odfURIResolver;
    /** The ametys object resolver */
    protected AmetysObjectResolver _resolver;
    /** The saxer */
    protected ReturnableSaxer _saxer;
    
    private PageReturnable _pageReturnable;

    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
        _odfPageResolver = (OdfPageResolver) manager.lookup(OdfPageResolver.ROLE);
        _odfHelper = (ODFHelper) manager.lookup(ODFHelper.ROLE);
        URIResolverExtensionPoint uriResolverEP = (URIResolverExtensionPoint) manager.lookup(URIResolverExtensionPoint.ROLE);
        _odfURIResolver = uriResolverEP.getResolverForType("odf");
        ReturnableExtensionPoint returnableEP = (ReturnableExtensionPoint) manager.lookup(ReturnableExtensionPoint.ROLE);
        _pageReturnable = (PageReturnable) returnableEP.getExtension(PageReturnable.ROLE);
    }
    
    @Override
    protected String associatedContentSearchableRole()
    {
        return CourseSearchable.ROLE;
    }
    
    @Override
    public String getId()
    {
        return ROLE;
    }
    
    @Override
    protected Function<Query, Query> siteQueryJoiner()
    {
        // Courses contents are "no-site" contents 
        return null;
    }
    
    @Override
    protected Set<String> getContentTypeIds(AdditionalParameterValueMap additionalParameterValues)
    {
        return Set.of(CourseFactory.COURSE_CONTENT_TYPE);
    }
    
    @Override
    public ReturnableSaxer getSaxer(Collection<Returnable> allReturnables, AdditionalParameterValueMap additionalParameterValues)
    {
        if (_saxer == null)
        {
            _saxer = new CourseSaxer(_pageReturnable, this);
        }
        return _saxer;
    }
    
    @Override
    protected String getSortDefinitionPrefix()
    {
        return __SORT_DEFINITION_PREFIX_ID;
    }
}

