/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.search.advanced.AbstractTreeNode;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.ConstantNilScoreQuery;
import org.ametys.cms.search.query.ContentTypeQuery;
import org.ametys.cms.search.query.IsolateQuery;
import org.ametys.cms.search.query.JoinQuery;
import org.ametys.cms.search.query.MaxScoreOrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.odfweb.service.search.ProgramReturnable;
import org.ametys.plugins.odfweb.service.search.helper.DegreeUniversityHelper;
import org.ametys.web.frontoffice.search.instance.model.SearchServiceCriterion;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.metamodel.SearchServiceCriterionDefinition;
import org.ametys.web.frontoffice.search.metamodel.Searchable;
import org.ametys.web.frontoffice.search.metamodel.impl.AbstractContentBasedSearchable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ProgramSearchable
extends AbstractContentBasedSearchable {
    public static final String ROLE = ProgramSearchable.class.getName();
    public static final String PARAMETER_SEARCH_ON_SUBPROGRAMS = "searchSubprogram";
    public static final String CRITERION_DEFINITIONS_PREFIX_ID = "ProgramSearchable$";
    public static final String PROGRAM_SEARCHEABLE_CRITERION_DEFINITION_PREFIX = "ProgramSearchable$org.ametys.plugins.odf.Content.program$";
    protected DegreeUniversityHelper _degreeUniversityHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._degreeUniversityHelper = (DegreeUniversityHelper)((Object)manager.lookup(DegreeUniversityHelper.ROLE));
    }

    protected String associatedContentReturnableRole() {
        return ProgramReturnable.ROLE;
    }

    protected String getCriterionDefinitionPrefix() {
        return CRITERION_DEFINITIONS_PREFIX_ID;
    }

    public Collection<Returnable> relationsWith() {
        return Arrays.asList(this._associatedContentReturnable);
    }

    protected Set<String> getContentTypeIds(AdditionalParameterValueMap additionalParameterValues) {
        return Set.of("org.ametys.plugins.odf.Content.program");
    }

    public Optional<Query> joinQuery(Query queryOnCriterion, SearchServiceCriterionDefinition criterion, Collection<Returnable> returnables, AdditionalParameterValueMap additionalParameters) {
        if (returnables.contains(this._associatedContentReturnable)) {
            return Optional.of(queryOnCriterion);
        }
        return Optional.empty();
    }

    public Query buildQuery(AbstractTreeNode<SearchServiceCriterion<?>> criterionTree, Map<String, Object> userCriteria, Collection<Returnable> returnables, Collection<Searchable> searchables, AdditionalParameterValueMap additionalParameters, String currentLang, Map<String, Object> contextualParameters) {
        Query query = super.buildQuery(criterionTree, userCriteria, returnables, searchables, additionalParameters, currentLang, contextualParameters);
        if (this._searchOnSubprograms(additionalParameters)) {
            return new MaxScoreOrQuery(new Query[]{new IsolateQuery(query), this.getProgramThroughSubprogramsQuery(query)});
        }
        return query;
    }

    private boolean _searchOnSubprograms(AdditionalParameterValueMap additionalParameters) {
        return (Boolean)additionalParameters.getValue(PARAMETER_SEARCH_ON_SUBPROGRAMS);
    }

    protected Query getProgramThroughSubprogramsQuery(Query queryOnCriterion) {
        AndQuery queryOnSubprograms = new AndQuery(new Query[]{new ConstantNilScoreQuery((Query)new ContentTypeQuery(new String[]{"org.ametys.plugins.odf.Content.subProgram"})), queryOnCriterion});
        return new ProgramThroughProgramPartsQuery((Query)queryOnSubprograms);
    }

    public Collection<SearchServiceCriterionDefinition> getCriteria(AdditionalParameterValueMap additionalParameterValues) {
        Collection criteria = super.getCriteria(additionalParameterValues);
        SearchServiceCriterionDefinition degreeUniversityCriterionDefinition = this._degreeUniversityHelper.getDegreeUniversityCriterionDefinition((Searchable)this);
        if (degreeUniversityCriterionDefinition != null) {
            criteria.add(degreeUniversityCriterionDefinition);
        }
        return criteria;
    }

    protected static class ProgramThroughProgramPartsQuery
    extends JoinQuery {
        protected ProgramThroughProgramPartsQuery(Query subQuery) {
            super(subQuery, new String[]{"childProgramParts"});
        }
    }
}

