/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.odfweb.repository.FirstLevelPageFactory;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InvalidateCacheOnSkillsModifiedObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    protected ContentTypesHelper _contentTypesHelper;
    protected AmetysObjectResolver _resolver;
    protected CacheInvalidationPolicy _cachePolicy;
    protected PageElementCache _zoneItemCache;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._cachePolicy = (CacheInvalidationPolicy)manager.lookup(CacheInvalidationPolicy.ROLE);
        this._zoneItemCache = (PageElementCache)manager.lookup(PageElementCache.ROLE + "/zoneItem");
    }

    public int getPriority() {
        return 0;
    }

    public boolean supports(Event event) {
        if (event.getId().equals("content.modified")) {
            Content content = (Content)event.getArguments().get("content");
            return this._contentTypesHelper.isInstanceOf(content, "org.ametys.plugins.odf.Content.macroSkill");
        }
        return false;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Content macroSkill = (Content)event.getArguments().get("content");
        String catalog = (String)macroSkill.getValue("catalog");
        this._getODFRootPages().stream().filter(odfRootPage -> catalog.equals(odfRootPage.getValue("odf-root-catalog"))).forEach(odfRootPage -> {
            try {
                this._cachePolicy.invalidateCacheOnPageModification(odfRootPage);
                this._zoneItemCache.clear(null, odfRootPage.getSiteName(), "CONTENT");
            }
            catch (Exception e) {
                this.getLogger().error("Error while invalidating cache for ODF root page '" + odfRootPage.getId() + "' after skill modification.", (Throwable)e);
            }
        });
    }

    protected AmetysObjectIterable<Page> _getODFRootPages() {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(FirstLevelPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)expression, null);
        return this._resolver.query(query);
    }
}

