/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.cachepolicy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.ametys.cms.ObservationConstants;
import org.ametys.web.cache.pageelement.AbstractSimplePageElementCachePolicy;
import org.ametys.web.cache.pageelement.PageElementCachePolicy;

/**
 * {@link PageElementCachePolicy} for the insert program service.
 */
public class InsertProgramServiceCachePolicy extends AbstractSimplePageElementCachePolicy
{

    /** The insert program service ID. */
    public static final String SERVICE_INSERT_PROGRAM_ID = "org.ametys.odf.service.InsertProgram";
    
    @Override
    public Set<String> getPageElementTypes()
    {
        return Collections.singleton("SERVICE:" + SERVICE_INSERT_PROGRAM_ID);
    }
    
    @Override
    protected List<String> _getRemovingCacheEventIds(String workspace)
    {
        if ("default".equals(workspace))
        {
            return Arrays.asList(ObservationConstants.EVENT_CONTENT_MODIFIED, ObservationConstants.EVENT_CONTENT_DELETED);
        }
        else if ("live".equals(workspace))
        {
            return Arrays.asList(ObservationConstants.EVENT_CONTENT_VALIDATED,
                                 ObservationConstants.EVENT_CONTENT_DELETED,
                                 ObservationConstants.EVENT_CONTENT_UNTAG_LIVE);
        }
        
        return Collections.emptyList();
    }

}
