/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var hideExtraFacets = function($facetDiv, maxCount)
{
    $options = $j('.options .option', $facetDiv);
    
    if ($options.length > maxCount)
    {
        $options.sort(sortByCountDesc).each(function(index) {
            if (index >= maxCount)
            {
                $j(this).hide();
            }
        });
        
        // Add the "more" links.
        $linkDiv = $j('<div class="all-links"></div>');
        $link = $j('<a class="see-all" href="#">{{i18n plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_SHOW_ALL_LINKS}}</a>');
        $link.click(function(){
            // Show all the options
            $j('.options .option', $j(this).parent().parent()).each(function(){
                $j(this).show();
            });
            // Remove the all-links div.
            $j(this).parent().remove();
            return false;
        });
        $link.appendTo($linkDiv);
        $linkDiv.appendTo($facetDiv);
    }
}

var sortByCountDesc = function(a, b)
{
    return parseCount($j(b)) - parseCount($j(a));
}

var parseCount = function($elt)
{
    var classes = $elt.attr('class').split(/\s+/);
    for (var i = 0; i < classes.length; i++)
    {
        if (classes[i].substring(0, 12) == 'facet-count-')
        {
            return parseInt(classes[i].substring(12));
        }
    }
    return 0;
}
