/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.cart;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.web.WebHelper;

/**
 * Subscribe to a ODF content
 *
 */
public class SubscribeODFCartAction extends ServiceableAction
{
    private ODFCartManager _cartManager;
    private CurrentUserProvider _currentUserProvider;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _cartManager = (ODFCartManager) smanager.lookup(ODFCartManager.ROLE);
        _currentUserProvider = (CurrentUserProvider) smanager.lookup(CurrentUserProvider.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map<String, Object> result = new HashMap<>();
               
        Request request = ObjectModelHelper.getRequest(objectModel);

        String siteName = WebHelper.getSiteName(request);
        
        UserIdentity owner = _currentUserProvider.getUser();
        
        String itemId = request.getParameter("itemId");
        boolean subscribe = Boolean.valueOf(request.getParameter("subscribe"));
        
        try
        {
            if (subscribe)
            {
                _cartManager.subscribe(owner, itemId, siteName);
            }
            else
            {
                _cartManager.unsubscribe(owner, itemId, siteName);
            }
            
            result.put("success", true);
            result.put("items", _cartManager.getItemIdsWithSubscription(owner, siteName));
        }
        catch (UserPreferencesException e)
        {
            getLogger().error("Failed to add subscription to content '" + itemId + "' for current user " + owner, e);
            result.put("success", false);
        }

        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        
        return EMPTY_MAP;
    }
    
}
