/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.ObservationConstants;
import org.ametys.web.repository.page.Page;

/**
 * {@link Observer} for invalidating the odf root cache in case of root page deletion
 */
public class InvalidateODFRootPageCacheOnPageDeleteObserver implements Observer, Serviceable
{
    
    private OdfPageHandler _odfPageHandler;
    private AmetysObjectResolver _resolver;


    public void service(ServiceManager manager) throws ServiceException
    {
        _odfPageHandler = (OdfPageHandler) manager.lookup(OdfPageHandler.ROLE);
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_PAGE_DELETING);
    }

    public int getPriority()
    {
        return MAX_PRIORITY + 4000;
    }


    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        String pageId = (String) event.getArguments().get(ObservationConstants.ARGS_PAGE_ID);
        Page page = _resolver.resolveById(pageId);
        if (_odfPageHandler.isODFRootPage(page))
        {
            _odfPageHandler.clearRootCache();
        }
    }

}
